/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.SapphireCommands;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireSection;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.sapphire.ui.actions.ActionsCommandBridge;
import org.eclipse.sapphire.ui.actions.ActionsRenderer;
import org.eclipse.sapphire.ui.actions.ShowHelpAction;
import org.eclipse.sapphire.ui.def.IEditorPageDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.CollapseAllAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.ExpandAllAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.HideOutlineAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.MergedNodeAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeAction;
import org.eclipse.sapphire.ui.internal.ActionsHostUtil;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.TableWrapLayoutUtil;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.sapphire.ui.util.internal.MutableReference;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsPage
extends SapphireEditorFormPage {
    public static final String ACTION_CONTEXT_HEADER = "header";
    public static final String ACTION_CONTEXT_OUTLINE_TOOLBAR = "outline-toolbar";
    public static final String ACTION_CONTEXT_OUTLINE_MENU = "outline-menu";
    static final String PREFS_CONTENT_TREE_STATE = "ContentTreeState";
    private static final String PREFS_VISIBLE = "Visible";
    private IEditorPageDef definition;
    private final MasterDetailsContentTree contentTree;
    private RootSection mainSection;
    private Map<String, List<ActionGroup>> actionsByContext = null;
    private ContentOutline contentOutlinePage;

    public MasterDetailsPage(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation) {
        this(editor, rootModelElement, pageDefinitionLocation, null);
    }

    public MasterDetailsPage(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation, String pageName) {
        super(editor, rootModelElement);
        String bundleId = pageDefinitionLocation.segment(0);
        String pageId = pageDefinitionLocation.lastSegment();
        String relPath = pageDefinitionLocation.removeFirstSegments(1).removeLastSegments(1).toPortableString();
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, relPath);
        for (IEditorPageDef pg : def.getEditorPageDefs()) {
            if (!pageId.equals(pg.getId().getText())) continue;
            this.definition = pg;
            break;
        }
        this.setPartName(pageName == null ? this.definition.getPageName().getText() : pageName);
        this.contentTree = new MasterDetailsContentTree(this, this.definition, rootModelElement);
    }

    @Override
    public String getId() {
        return this.getPartName();
    }

    @Override
    public String getHelpContextId() {
        return this.definition.getHelpContextId().getText();
    }

    public MasterDetailsContentTree getContentTree() {
        return this.contentTree;
    }

    public void expandAllNodes() {
        for (MasterDetailsContentNode node : this.getContentTree().getRoot().getChildNodes()) {
            node.setExpanded(true, true);
        }
    }

    public void collapseAllNodes() {
        for (MasterDetailsContentNode node : this.getContentTree().getRoot().getChildNodes()) {
            node.setExpanded(false, true);
        }
    }

    public IDetailsPage getCurrentDetailsPage() {
        return this.mainSection.getCurrentDetailsSection();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(managedForm.getForm().getForm());
        form.setText(this.definition.getPageHeaderText().getLocalizedText());
        this.mainSection = new RootSection(this.getModel());
        this.mainSection.createContent(managedForm);
        String helpContextId = this.definition.getHelpContextId().getText();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)managedForm.getForm().getBody(), helpContextId);
        }
        IToolBarManager toolbarManager = form.getToolBarManager();
        ActionsRenderer.fillToolBarManager(toolbarManager, form.getShell(), this.getActions(ACTION_CONTEXT_HEADER));
        ((ToolBarManager)toolbarManager).getControl().setCursor(null);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new ContentOutline();
        }
        return this.contentOutlinePage;
    }

    public boolean isDetailsMaximized() {
        try {
            boolean contentTreeVisible;
            Preferences prefs = this.getInstancePreferences(false);
            if (prefs != null && prefs.nodeExists(PREFS_CONTENT_TREE_STATE) && !(contentTreeVisible = (prefs = prefs.node(PREFS_CONTENT_TREE_STATE)).getBoolean(PREFS_VISIBLE, true))) {
                return true;
            }
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        return false;
    }

    public void setDetailsMaximized(boolean maximized) {
        this.mainSection.setDetailsMaximized(maximized);
        try {
            Preferences prefs = this.getInstancePreferences(true).node(PREFS_CONTENT_TREE_STATE);
            prefs.putBoolean(PREFS_VISIBLE, !maximized);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public List<ActionGroup> getActions(String context) {
        this.initActions();
        List<ActionGroup> actions = this.actionsByContext.get(context);
        if (actions != null) {
            return actions;
        }
        return Collections.emptyList();
    }

    @Override
    public Action getAction(String id) {
        this.initActions();
        for (List<ActionGroup> actions : this.actionsByContext.values()) {
            for (ActionGroup group : actions) {
                Action action = group.getAction(id);
                if (action == null) continue;
                return action;
            }
        }
        return null;
    }

    private List<ActionGroup> getNodeActions(List<MasterDetailsContentNode> nodes, String context) {
        ArrayList<ActionGroup> result = new ArrayList<ActionGroup>();
        if (!nodes.isEmpty() && context != null && context.equals(ACTION_CONTEXT_OUTLINE_MENU)) {
            if (nodes.size() == 1) {
                result.addAll(nodes.get(0).getMenuActions());
            } else {
                ArrayList index = new ArrayList();
                for (MasterDetailsContentNode node : nodes) {
                    HashMap<String, NodeAction> nodeIndex = new HashMap<String, NodeAction>();
                    index.add(nodeIndex);
                    for (ActionGroup group : node.getMenuActions()) {
                        for (Action action : group.getActions()) {
                            nodeIndex.put(action.getId(), (NodeAction)action);
                        }
                    }
                }
                for (ActionGroup group : nodes.get(0).getMenuActions()) {
                    ArrayList<Action> actions = new ArrayList<Action>();
                    for (Action action : group.getActions()) {
                        String id = action.getId();
                        if (!((NodeAction)action).isMergingAllowed()) continue;
                        ArrayList<NodeAction> actionsToMerge = new ArrayList<NodeAction>();
                        for (Map map : index) {
                            Action a = (Action)map.get(id);
                            if (a != null) {
                                actionsToMerge.add((NodeAction)a);
                                continue;
                            }
                            actionsToMerge = null;
                            break;
                        }
                        if (actionsToMerge == null) continue;
                        MergedNodeAction mergedNodeAction = new MergedNodeAction();
                        mergedNodeAction.setId(id);
                        mergedNodeAction.setCommandId(action.getCommandId());
                        mergedNodeAction.setType(action.getType());
                        mergedNodeAction.setLabel(action.getLabel());
                        mergedNodeAction.setPart(this);
                        mergedNodeAction.setImageDescriptor(action.getImageDescriptor());
                        if (mergedNodeAction.getImageDescriptor() == null) {
                            mergedNodeAction.setImageDescriptor(action.getImageDescriptor());
                        }
                        for (NodeAction a : actionsToMerge) {
                            mergedNodeAction.addAction(a);
                        }
                        actions.add(mergedNodeAction);
                    }
                    if (actions.isEmpty()) continue;
                    result.add(new ActionGroup(actions));
                }
            }
        }
        result.addAll(this.getActions(context));
        return result;
    }

    private void initActions() {
        if (this.actionsByContext == null) {
            this.actionsByContext = new HashMap<String, List<ActionGroup>>();
            ArrayList<ActionGroup> headerActionSet = new ArrayList<ActionGroup>();
            ActionGroup defaultHeaderActions = new ActionGroup();
            defaultHeaderActions.addAction(new HideOutlineAction());
            defaultHeaderActions.addAction(new ShowHelpAction());
            headerActionSet.add(defaultHeaderActions);
            ActionsHostUtil.initActions(headerActionSet, this.definition.getHeaderActionSetDef());
            this.actionsByContext.put(ACTION_CONTEXT_HEADER, headerActionSet);
            ArrayList<ActionGroup> outlineToolbarActionSet = new ArrayList<ActionGroup>();
            ActionGroup expandAllCollapseAllActions = new ActionGroup();
            expandAllCollapseAllActions.addAction(new ExpandAllAction());
            expandAllCollapseAllActions.addAction(new CollapseAllAction());
            outlineToolbarActionSet.add(expandAllCollapseAllActions);
            ActionsHostUtil.initActions(outlineToolbarActionSet, this.definition.getOutlineToolbarActionSetDef());
            this.actionsByContext.put(ACTION_CONTEXT_OUTLINE_TOOLBAR, outlineToolbarActionSet);
            ArrayList<ActionGroup> outlineMenuActionSet = new ArrayList<ActionGroup>();
            ActionsHostUtil.initActions(outlineMenuActionSet, this.definition.getOutlineMenuActionSetDef());
            this.actionsByContext.put(ACTION_CONTEXT_OUTLINE_MENU, outlineMenuActionSet);
            for (List<ActionGroup> actions : this.actionsByContext.values()) {
                for (ActionGroup group : actions) {
                    for (Action action : group.getActions()) {
                        action.setPart(this);
                    }
                }
            }
        }
    }

    public void setFocus() {
        if (this.isDetailsMaximized()) {
            this.setFocusOnDetails();
        } else {
            this.setFocusOnContentOutline();
        }
    }

    public void setFocusOnContentOutline() {
        if (this.isDetailsMaximized()) {
            this.setDetailsMaximized(false);
        }
        this.mainSection.masterSection.tree.setFocus();
    }

    public void setFocusOnDetails() {
        Control control = this.findFirstFocusableControl(this.mainSection.detailsSectionControl);
        if (control != null) {
            control.setFocus();
        }
    }

    private Control findFirstFocusableControl(Control control) {
        if (control instanceof Text || control instanceof Combo || control instanceof Link || control instanceof List || control instanceof Table || control instanceof Tree) {
            return control;
        }
        if (control instanceof Text) {
            if ((((Text)control).getStyle() & 8) == 0) {
                return control;
            }
        } else if (control instanceof Button) {
            int style = control.getStyle();
            if ((style & 0x20) != 0 || (style & 0x10) != 0) {
                return control;
            }
        } else if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Control res = this.findFirstFocusableControl(child);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    private FilteredTree createContentOutline(Composite parent, final MasterDetailsContentTree contentTree, boolean addBorders) {
        int treeStyle = (addBorders ? 2048 : 0) | 2;
        final ContentOutlineFilteredTree filteredTree = new ContentOutlineFilteredTree(parent, treeStyle, contentTree);
        final TreeViewer treeViewer = filteredTree.getViewer();
        SapphireCommands.configureContentOutlineContext((Control)treeViewer.getTree());
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return contentTree.getRoot().getChildNodes().toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((MasterDetailsContentNode)parentElement).getChildNodes().toArray();
            }

            public Object getParent(Object element) {
                return ((MasterDetailsContentNode)element).getParentNode();
            }

            public boolean hasChildren(Object element) {
                return ((MasterDetailsContentNode)element).getChildNodes().size() > 0;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        LabelProvider labelProvider = new LabelProvider(){
            private final Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

            public String getText(Object element) {
                return ((MasterDetailsContentNode)element).getLabel();
            }

            public Image getImage(Object element) {
                return this.getImage((MasterDetailsContentNode)element);
            }

            private Image getImage(MasterDetailsContentNode node) {
                ImageDescriptor imageDescriptor = node.getImageDescriptor();
                Image image = this.images.get(imageDescriptor);
                if (image == null) {
                    image = imageDescriptor.createImage();
                    this.images.put(imageDescriptor, image);
                }
                return image;
            }

            public void dispose() {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
            }
        };
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        treeViewer.setInput(new Object());
        final MutableReference<Boolean> ignoreSelectionChange = new MutableReference<Boolean>(false);
        final MutableReference<Boolean> ignoreExpandedStateChange = new MutableReference<Boolean>(false);
        final MasterDetailsContentTree.Listener contentTreeListener = new MasterDetailsContentTree.Listener(){

            @Override
            public void handleNodeUpdate(MasterDetailsContentNode node) {
                treeViewer.update((Object)node, null);
            }

            @Override
            public void handleNodeStructureChange(MasterDetailsContentNode node) {
                treeViewer.refresh((Object)node);
            }

            @Override
            public void handleSelectionChange(List<MasterDetailsContentNode> selection) {
                if (((Boolean)ignoreSelectionChange.get()).booleanValue()) {
                    return;
                }
                StructuredSelection sel = selection.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection(selection);
                if (!treeViewer.getSelection().equals(sel)) {
                    for (MasterDetailsContentNode node : selection) {
                        treeViewer.reveal((Object)node);
                    }
                    treeViewer.setSelection((ISelection)sel);
                }
            }

            @Override
            public void handleNodeExpandedStateChange(MasterDetailsContentNode node) {
                if (((Boolean)ignoreExpandedStateChange.get()).booleanValue()) {
                    return;
                }
                boolean expandedState = node.isExpanded();
                if (treeViewer.getExpandedState((Object)node) != expandedState) {
                    treeViewer.setExpandedState((Object)node, expandedState);
                }
            }

            @Override
            public void handleFilterChange(String newFilterText) {
                filteredTree.changeFilterText(newFilterText);
            }
        };
        contentTree.addListener(contentTreeListener);
        treeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                contentTree.removeListener(contentTreeListener);
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ignoreSelectionChange.set(true);
                try {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ArrayList<MasterDetailsContentNode> nodes = new ArrayList<MasterDetailsContentNode>();
                    Iterator itr = selection.iterator();
                    while (itr.hasNext()) {
                        nodes.add((MasterDetailsContentNode)itr.next());
                    }
                    contentTree.setSelectedNodes(nodes);
                }
                finally {
                    ignoreSelectionChange.set(false);
                }
            }
        });
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                ignoreExpandedStateChange.set(true);
                try {
                    MasterDetailsContentNode node = (MasterDetailsContentNode)event.getElement();
                    node.setExpanded(true);
                }
                finally {
                    ignoreExpandedStateChange.set(false);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                ignoreExpandedStateChange.set(true);
                try {
                    MasterDetailsContentNode node = (MasterDetailsContentNode)event.getElement();
                    node.setExpanded(false);
                }
                finally {
                    ignoreExpandedStateChange.set(false);
                }
            }
        });
        Tree tree = treeViewer.getTree();
        final Menu menu = new Menu((Control)tree);
        tree.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                List<MasterDetailsContentNode> selection = contentTree.getSelectedNodes();
                if (!selection.isEmpty()) {
                    List actions = MasterDetailsPage.this.getNodeActions(selection, MasterDetailsPage.ACTION_CONTEXT_OUTLINE_MENU);
                    ActionsRenderer.fillMenu(menu, actions);
                }
            }
        });
        treeViewer.setExpandedElements(contentTree.getExpandedNodes().toArray());
        contentTreeListener.handleSelectionChange(contentTree.getSelectedNodes());
        filteredTree.changeFilterText(contentTree.getFilterText());
        return filteredTree;
    }

    private static void updateExpandedState(MasterDetailsContentTree contentTree, Tree tree) {
        HashSet<MasterDetailsContentNode> expandedNodes = new HashSet<MasterDetailsContentNode>();
        MasterDetailsPage.gatherExpandedNodes(tree.getItems(), expandedNodes);
        contentTree.setExpandedNodes(expandedNodes);
    }

    private static void gatherExpandedNodes(TreeItem[] items, Set<MasterDetailsContentNode> result) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getExpanded()) {
                result.add((MasterDetailsContentNode)item.getData());
                MasterDetailsPage.gatherExpandedNodes(item.getItems(), result);
            }
            ++n2;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getContentTree().dispose();
        if (this.mainSection != null) {
            this.mainSection.dispose();
        }
    }

    private final class ContentOutline
    extends Page
    implements IContentOutlinePage {
        private Composite outerComposite = null;
        private FilteredTree filteredTree = null;
        private TreeViewer treeViewer = null;
        private IToolBarManager toolBarManager = null;
        private ActionsCommandBridge actionsCommandBridge = null;

        private ContentOutline() {
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            pageSite.setSelectionProvider((ISelectionProvider)this);
        }

        public void createControl(Composite parent) {
            this.outerComposite = new Composite(parent, 0);
            this.outerComposite.setLayout((Layout)SwtUtil.glayout(1, 5, 5));
            this.outerComposite.setBackground(Display.getCurrent().getSystemColor(1));
            this.filteredTree = MasterDetailsPage.this.createContentOutline(this.outerComposite, MasterDetailsPage.this.getContentTree(), false);
            this.filteredTree.setLayoutData((Object)SwtUtil.gdfill());
            this.treeViewer = this.filteredTree.getViewer();
            this.toolBarManager = this.getSite().getActionBars().getToolBarManager();
            this.actionsCommandBridge = new ActionsCommandBridge((Control)this.treeViewer.getTree());
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ContentOutline.this.refreshActions();
                }
            });
            this.refreshActions();
        }

        private void refreshActions() {
            IContributionItem[] iContributionItemArray = this.toolBarManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                this.toolBarManager.remove(item);
                ++n2;
            }
            List<MasterDetailsContentNode> selection = MasterDetailsPage.this.getContentTree().getSelectedNodes();
            List actions = MasterDetailsPage.this.getNodeActions(selection, MasterDetailsPage.ACTION_CONTEXT_OUTLINE_TOOLBAR);
            ActionsRenderer.fillToolBarManager(this.toolBarManager, MasterDetailsPage.this.getEditor().getSite().getShell(), actions);
            this.actionsCommandBridge.setActions(MasterDetailsPage.this.getNodeActions(selection, MasterDetailsPage.ACTION_CONTEXT_OUTLINE_MENU));
        }

        public Control getControl() {
            return this.outerComposite;
        }

        public void setFocus() {
            this.treeViewer.getControl().setFocus();
        }

        public ISelection getSelection() {
            if (this.treeViewer == null) {
                return StructuredSelection.EMPTY;
            }
            return this.treeViewer.getSelection();
        }

        public void setSelection(ISelection selection) {
            if (this.treeViewer != null) {
                this.treeViewer.setSelection(selection);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }
    }

    private static final class ContentOutlineFilteredTree
    extends FilteredTree {
        private final MasterDetailsContentTree contentTree;
        private WorkbenchJob refreshJob;

        public ContentOutlineFilteredTree(Composite parent, int treeStyle, MasterDetailsContentTree contentTree) {
            super(parent, treeStyle, new PatternFilter(), true);
            this.contentTree = contentTree;
            this.setBackground(Display.getCurrent().getSystemColor(1));
        }

        protected WorkbenchJob doCreateRefreshJob() {
            final WorkbenchJob base = super.doCreateRefreshJob();
            this.refreshJob = new WorkbenchJob(base.getName()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IStatus st = base.runInUIThread((IProgressMonitor)new NullProgressMonitor());
                    if (st.getSeverity() == 8) {
                        return st;
                    }
                    ContentOutlineFilteredTree.this.contentTree.setFilterText(ContentOutlineFilteredTree.this.getFilterString());
                    MasterDetailsPage.updateExpandedState(ContentOutlineFilteredTree.this.contentTree, ContentOutlineFilteredTree.this.getViewer().getTree());
                    return Status.OK_STATUS;
                }
            };
            return this.refreshJob;
        }

        public void changeFilterText(String filterText) {
            String currentFilterText = this.getFilterString();
            if (currentFilterText != null && !currentFilterText.equals(filterText)) {
                this.setFilterText(filterText);
                this.textChanged();
            }
        }
    }

    private static class DetailsSection
    extends SapphireRenderingContext
    implements IDetailsPage {
        protected final MasterDetailsPage mainPage;
        private MasterDetailsContentNode node;
        protected IManagedForm mform;
        protected FormToolkit toolkit;

        public DetailsSection(MasterDetailsPage mainPage) {
            super(null, null);
            this.mainPage = mainPage;
            this.node = null;
        }

        public SapphirePart getPart() {
            return this.node;
        }

        public void initialize(IManagedForm form) {
            this.mform = form;
            this.toolkit = this.mform.getToolkit();
        }

        public final void createContents(Composite parent) {
            this.composite = parent;
            TableWrapLayout twl = TableWrapLayoutUtil.twlayout(1, 10, 10, 10, 10);
            twl.verticalSpacing = 20;
            parent.setLayout((Layout)twl);
            this.createSections();
        }

        public void commit(boolean onSave) {
        }

        public void dispose() {
        }

        public boolean isDirty() {
            return false;
        }

        public boolean isStale() {
            return false;
        }

        public void refresh() {
        }

        public void setFocus() {
        }

        public boolean setFormInput(Object input) {
            return false;
        }

        public void adapt(Control control) {
            super.adapt(control);
            if (control instanceof Composite) {
                this.toolkit.adapt((Composite)control);
            } else if (control instanceof Label) {
                this.toolkit.adapt(control, false, false);
            } else {
                this.toolkit.adapt(control, true, true);
            }
        }

        protected String getHelpContextIdPrefix() {
            return this.mainPage.getEditor().getHelpContextIdPrefix();
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            this.node = ssel.size() == 1 ? (MasterDetailsContentNode)ssel.getFirstElement() : null;
            this.createSections();
        }

        protected void createSections() {
            Composite rootComposite = this.getComposite();
            Control[] controlArray = rootComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setVisible(false);
                control.dispose();
                ++n2;
            }
            if (this.node != null) {
                for (SapphireSection section : this.node.getSections()) {
                    if (!section.checkVisibleWhenCondition()) continue;
                    section.render(this);
                }
            }
            rootComposite.getParent().layout(true, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MasterSection
    extends Section {
        private IManagedForm managedForm;
        private SectionPart sectionPart;
        private TreeViewer treeViewer;
        private Tree tree;
        private ToolBar toolbar;
        private boolean editorLevelNavToolBarActionsPresent;
        private List<ActionGroup> actions;
        private final ActionsCommandBridge actionsCommandBridge;

        public MasterSection(IManagedForm managedForm, Composite parent) {
            super(parent, 256);
            this.editorLevelNavToolBarActionsPresent = false;
            FormToolkit toolkit = managedForm.getToolkit();
            FormColors colors = toolkit.getColors();
            this.setMenu(parent.getMenu());
            toolkit.adapt((Control)this, true, true);
            if (this.toggle != null) {
                this.toggle.setHoverDecorationColor(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
                this.toggle.setDecorationColor(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
            }
            this.setFont(this.createBoldFont(colors.getDisplay(), this.getFont()));
            colors.initializeSectionToolBarColors();
            this.setTitleBarBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
            this.setTitleBarBorderColor(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
            this.setTitleBarForeground(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
            this.marginWidth = 10;
            this.marginHeight = 10;
            this.setLayoutData(SwtUtil.gdfill());
            this.setLayout((Layout)SwtUtil.glayout(1, 0, 0));
            this.setText(MasterDetailsPage.this.definition.getOutlineHeaderText().getLocalizedText());
            Composite client = toolkit.createComposite((Composite)this);
            client.setLayout((Layout)SwtUtil.glayout(1, 0, 0));
            this.managedForm = managedForm;
            MasterDetailsContentTree contentTree = MasterDetailsPage.this.getContentTree();
            FilteredTree filteredTree = MasterDetailsPage.this.createContentOutline(client, contentTree, true);
            this.treeViewer = filteredTree.getViewer();
            this.tree = this.treeViewer.getTree();
            this.sectionPart = new SectionPart((Section)this);
            this.managedForm.addPart((IFormPart)this.sectionPart);
            contentTree.addListener(new MasterDetailsContentTree.Listener(){

                @Override
                public void handleSelectionChange(List<MasterDetailsContentNode> selection) {
                    MasterSection.this.handleSelectionChangedEvent(selection);
                }
            });
            GridLayout toolbarsCompositeLayout = SwtUtil.glayout(2, 0, 0);
            toolbarsCompositeLayout.horizontalSpacing = 0;
            toolbarsCompositeLayout.verticalSpacing = 0;
            List<ActionGroup> editorLevelNavigationToolBarActions = MasterDetailsPage.this.getActions(MasterDetailsPage.ACTION_CONTEXT_OUTLINE_TOOLBAR);
            if (editorLevelNavigationToolBarActions.isEmpty()) {
                this.editorLevelNavToolBarActionsPresent = false;
                this.toolbar = new ToolBar((Composite)this, 0x800100);
                this.setTextClient((Control)this.toolbar);
            } else {
                this.editorLevelNavToolBarActionsPresent = true;
                Composite toolbarsComposite = new Composite((Composite)this, 0);
                toolbarsComposite.setLayout((Layout)toolbarsCompositeLayout);
                this.toolbar = new ToolBar(toolbarsComposite, 0x800100);
                this.toolbar.setLayoutData((Object)SwtUtil.gdhfill());
                ToolBar editorLevelActionsToolbar = new ToolBar(toolbarsComposite, 0x800100);
                editorLevelActionsToolbar.setLayoutData((Object)SwtUtil.gdhfill());
                ActionsRenderer.fillToolBar(editorLevelActionsToolbar, MasterDetailsPage.this.getActions(MasterDetailsPage.ACTION_CONTEXT_OUTLINE_TOOLBAR));
                this.setTextClient((Control)toolbarsComposite);
            }
            this.actionsCommandBridge = new ActionsCommandBridge((Control)this.tree);
            toolkit.paintBordersFor((Composite)this);
            this.setClient((Control)client);
        }

        private Font createBoldFont(Display display, Font regularFont) {
            FontData[] fontDatas = regularFont.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setStyle(fontDatas[i].getStyle() | 1);
                ++i;
            }
            return new Font((Device)display, fontDatas);
        }

        public void refreshActions() {
            ToolItem[] toolItemArray = this.toolbar.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                item.dispose();
                ++n2;
            }
            List<MasterDetailsContentNode> selection = MasterDetailsPage.this.getContentTree().getSelectedNodes();
            this.actions = MasterDetailsPage.this.getNodeActions(selection, null);
            ActionsRenderer.fillToolBar(this.toolbar, this.actions, this.editorLevelNavToolBarActionsPresent);
            this.actionsCommandBridge.setActions(MasterDetailsPage.this.getNodeActions(selection, MasterDetailsPage.ACTION_CONTEXT_OUTLINE_MENU));
            this.toolbar.getParent().getParent().layout(true, true);
        }

        private void handleSelectionChangedEvent(List<MasterDetailsContentNode> selection) {
            StructuredSelection sel = selection.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection((Object)selection.get(0));
            this.managedForm.fireSelectionChanged((IFormPart)this.sectionPart, (ISelection)sel);
            this.refreshActions();
        }
    }

    private final class RootSection
    extends MasterDetailsBlock {
        private MasterSection masterSection;
        private List<IDetailsPage> detailsSections = new ArrayList<IDetailsPage>();
        private Control detailsSectionControl = null;

        public RootSection(IModel descriptor) {
        }

        public void createContent(IManagedForm managedForm) {
            super.createContent(managedForm);
            this.sashForm.setWeights(new int[]{3, 7});
            try {
                Field field = this.detailsPart.getClass().getDeclaredField("pageBook");
                field.setAccessible(true);
                this.detailsSectionControl = (Control)field.get(this.detailsPart);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
            this.masterSection.handleSelectionChangedEvent(MasterDetailsPage.this.getContentTree().getSelectedNodes());
            this.setDetailsMaximized(MasterDetailsPage.this.isDetailsMaximized());
        }

        protected void createMasterPart(IManagedForm managedForm, Composite parent) {
            this.masterSection = new MasterSection(managedForm, parent);
            SectionPart spart = new SectionPart((Section)this.masterSection);
            managedForm.addPart((IFormPart)spart);
        }

        protected void registerPages(DetailsPart detailsPart) {
            DetailsSection detailsPage = new DetailsSection(MasterDetailsPage.this);
            detailsPart.registerPage(MasterDetailsContentNode.class, (IDetailsPage)detailsPage);
            this.detailsSections.add(detailsPage);
        }

        protected void applyLayoutData(SashForm sashForm) {
            sashForm.setLayoutData((Object)SwtUtil.gdwhint(SwtUtil.gdhhint(SwtUtil.gdfill(), 200), 400));
        }

        public IDetailsPage getCurrentDetailsSection() {
            return this.detailsPart.getCurrentPage();
        }

        public void setDetailsMaximized(boolean maximized) {
            this.sashForm.setMaximizedControl(maximized ? this.detailsSectionControl : null);
        }

        public void dispose() {
            if (this.masterSection != null) {
                this.masterSection.dispose();
            }
            for (IDetailsPage section : this.detailsSections) {
                section.dispose();
            }
        }

        protected void createToolBarActions(IManagedForm managedForm) {
        }
    }
}

