/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails.actions;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeAction;
import org.eclipse.swt.widgets.Shell;

public class NodeAddAction
extends NodeAction {
    public static final String ACTION_ID = "node:add";
    public static final String ACTION_ID_PREFIX = "node:add:";
    private MasterDetailsContentTree contentTree = null;
    private MasterDetailsContentTree.Listener contentTreeListener = null;

    public NodeAddAction() {
        this.setId(ACTION_ID);
        this.setImageDescriptor(SapphireImageCache.ACTION_ADD);
    }

    public boolean isEnabled() {
        return this.contentTree != null && this.contentTree.getFilterText().length() == 0;
    }

    public void setPart(ISapphirePart part) {
        String label;
        super.setPart(part);
        this.contentTree = this.getNode().getContentTree();
        this.contentTreeListener = new MasterDetailsContentTree.Listener(){

            public void handleFilterChange(String newFilterText) {
                NodeAddAction.this.notifyChangeListeners();
            }
        };
        this.contentTree.addListener(this.contentTreeListener);
        MasterDetailsContentNode node = this.getNode();
        List<ListProperty> listProperties = node.getChildListProperties();
        if (listProperties.size() > 1 || listProperties.get(0).getAllPossibleTypes().size() > 1) {
            label = Resources.addActionLabel;
        } else {
            ModelElementType type = (ModelElementType)listProperties.get(0).getAllPossibleTypes().get(0);
            label = NLS.bind((String)Resources.addActionLabelQualified, (Object)type.getLabel(true, CapitalizationType.TITLE_STYLE, false));
        }
        this.setLabel(label);
        this.createChildActions();
    }

    protected void createChildActions() {
        MasterDetailsContentNode node = this.getNode();
        List<ListProperty> listProperties = node.getChildListProperties();
        if (listProperties.size() > 1 || listProperties.get(0).getAllPossibleTypes().size() > 1) {
            ActionGroup mainAddActionGroup = new ActionGroup();
            this.addChildActionGroup(mainAddActionGroup);
            for (ListProperty listProperty : listProperties) {
                for (ModelElementType memberType : listProperty.getAllPossibleTypes()) {
                    TypeSpecificAddAction typeSpecificAddAction = new TypeSpecificAddAction(listProperty, memberType);
                    typeSpecificAddAction.setPart(this.getPart());
                    mainAddActionGroup.addAction(typeSpecificAddAction);
                }
            }
        }
    }

    protected Object run(Shell shell) {
        if (!this.getChildActionGroups().isEmpty()) {
            throw new UnsupportedOperationException();
        }
        MasterDetailsContentNode node = this.getNode();
        ListProperty property = node.getChildListProperties().get(0);
        return this.performAddAction(shell, property, property.getType());
    }

    private IModelElement performAddAction(Shell shell, ListProperty property, ModelElementType type) {
        if (!this.checkFilter(shell)) {
            return null;
        }
        MasterDetailsContentNode node = this.getNode();
        IModelElement modelElement = node.getLocalModelElement();
        ModelElementList list = (ModelElementList)property.invokeGetterMethod((Object)modelElement);
        IModelElement newModelElement = list.addNewElement(type);
        node.getContentTree().notifyOfNodeStructureChange(node);
        for (MasterDetailsContentNode n : node.getChildNodes()) {
            if (n.getModelElement() != newModelElement) continue;
            n.select();
            this.getPart().getNearestPart(MasterDetailsPage.class).setFocusOnDetails();
            break;
        }
        return newModelElement;
    }

    public void dispose() {
        super.dispose();
        if (this.contentTree != null) {
            this.contentTree.removeListener(this.contentTreeListener);
        }
    }

    protected boolean checkFilter(Shell shell) {
        if (this.contentTree.getFilterText().length() > 0) {
            MessageDialog.openError((Shell)shell, (String)Resources.filterPresentDialogTitle, (String)Resources.filterPresentDialogMessage);
            return false;
        }
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String addActionLabel;
        public static String addActionLabelQualified;
        public static String filterPresentDialogTitle;
        public static String filterPresentDialogMessage;

        static {
            Resources.initializeMessages((String)NodeAddAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private final class TypeSpecificAddAction
    extends NodeAction {
        private final ListProperty listProperty;
        private final ModelElementType type;

        public TypeSpecificAddAction(ListProperty listProperty, ModelElementType type) {
            this.listProperty = listProperty;
            this.type = type;
            ImageDescriptor typeSpecificAddImage = NodeAddAction.this.getPart().getImageCache().getImageDescriptor(this.type);
            if (typeSpecificAddImage == null) {
                typeSpecificAddImage = NodeAddAction.this.getImageDescriptor();
            }
            this.setId(NodeAddAction.ACTION_ID_PREFIX + this.type.getModelElementClass().getSimpleName());
            this.setLabel(this.type.getLabel(false, CapitalizationType.TITLE_STYLE, false));
            this.setImageDescriptor(typeSpecificAddImage);
        }

        protected Object run(Shell shell) {
            if (!NodeAddAction.this.checkFilter(shell)) {
                return null;
            }
            return NodeAddAction.this.performAddAction(shell, this.listProperty, this.type);
        }
    }
}

