/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeMoveAction;
import org.eclipse.swt.widgets.Shell;

public class NodeMoveUpAction
extends NodeMoveAction {
    public static final String ACTION_ID = "node:move-up";

    public NodeMoveUpAction() {
        this.setId(ACTION_ID);
        this.setLabel(Resources.moveUpActionLabel);
        this.setImageDescriptor(SapphireImageCache.ACTION_MOVE_UP);
        this.setCommandId("sapphire.move.up");
    }

    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        IModelElement modelElement = this.getNode().getModelElement();
        ModelElementList list = (ModelElementList)modelElement.getParent();
        return list.indexOf((Object)modelElement) > 0;
    }

    protected final Object run(Shell shell) {
        MasterDetailsContentNode node = this.getNode();
        IModelElement modelElement = node.getModelElement();
        ModelElementList list = (ModelElementList)modelElement.getParent();
        list.moveUp(modelElement);
        node.getContentTree().notifyOfNodeStructureChange(node.getParentNode());
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String moveUpActionLabel;

        static {
            Resources.initializeMessages((String)NodeMoveUpAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

