/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPropertyNodeFactory {
    private final IModelElement modelElement;
    private final ListProperty listProperty;
    private Map<Object, MasterDetailsContentNode> nodesCache;
    private final SapphireCondition visibleWhenCondition;

    public ListPropertyNodeFactory(IModelElement modelElement, ListProperty listProperty, SapphireCondition visibleWhenCondition) {
        if (modelElement == null) {
            throw new IllegalArgumentException();
        }
        if (listProperty == null) {
            throw new IllegalArgumentException();
        }
        this.modelElement = modelElement;
        this.listProperty = listProperty;
        this.nodesCache = null;
        this.visibleWhenCondition = visibleWhenCondition;
    }

    public final boolean isVisible() {
        if (this.visibleWhenCondition != null) {
            return this.visibleWhenCondition.evaluate();
        }
        return true;
    }

    public ListProperty getListProperty() {
        return this.listProperty;
    }

    public List<MasterDetailsContentNode> createNodes() {
        ModelElementList list;
        HashMap<Object, MasterDetailsContentNode> newCache = new HashMap<Object, MasterDetailsContentNode>();
        ArrayList<MasterDetailsContentNode> nodes = new ArrayList<MasterDetailsContentNode>();
        try {
            list = (ModelElementList)this.listProperty.invokeGetterMethod((Object)this.modelElement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (IModelElement listEntryModelElement : list) {
            MasterDetailsContentNode node;
            MasterDetailsContentNode masterDetailsContentNode = node = this.nodesCache != null ? this.nodesCache.get(listEntryModelElement) : null;
            if (node == null) {
                node = this.createNode(listEntryModelElement);
            }
            nodes.add(node);
            newCache.put(listEntryModelElement, node);
        }
        this.nodesCache = newCache;
        return nodes;
    }

    protected abstract MasterDetailsContentNode createNode(IModelElement var1);
}

