/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal.binding;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.binding.AbstractEnumBinding;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public final class RadioButtonsGroupBinding
extends AbstractEnumBinding {
    private RadioButtonsGroup buttonsGroup;
    private Button badValueButton;

    public RadioButtonsGroupBinding(IModelElement modelElement, ValueProperty property, SapphireRenderingContext context, RadioButtonsGroup buttonsGroup) {
        super(modelElement, property, context, (Control)buttonsGroup);
    }

    protected void initialize(IModelElement modelElement, ModelProperty property, SapphireRenderingContext context, Control control) {
        super.initialize(modelElement, property, context, control);
        this.buttonsGroup = (RadioButtonsGroup)control;
        EnumValueType enumValueType = new EnumValueType(this.enumValues[0].getDeclaringClass());
        Enum[] enumArray = this.enumValues;
        int n = this.enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            Enum enumItem = enumArray[n2];
            Button button = this.buttonsGroup.addRadioButton(enumValueType.getLabel(enumItem, false, CapitalizationType.FIRST_WORD_ONLY, true));
            button.setData((Object)enumItem);
            ++n2;
        }
        this.buttonsGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RadioButtonsGroupBinding.this.updateModel();
                RadioButtonsGroupBinding.this.updateTargetAttributes();
            }
        });
    }

    protected int getSelectionIndex() {
        return this.buttonsGroup.getSelectionIndex();
    }

    protected void setSelectionIndex(int index) {
        this.buttonsGroup.setSelectionIndex(index);
    }

    protected void createMalformedItem(String label) {
        if (this.badValueButton == null) {
            this.badValueButton = this.buttonsGroup.addRadioButton("");
        }
        this.badValueButton.setText(label);
        this.getContext().layout();
    }

    protected void removeMalformedItem() {
        if (this.badValueButton != null) {
            this.badValueButton.dispose();
            this.badValueButton = null;
            this.getContext().layout();
        }
    }
}

