/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal.binding;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextFieldBinding
extends AbstractBinding {
    private Text text;
    private String textContent;
    private DelayedTasksExecutor.Task onTextContentModifyTask;

    public TextFieldBinding(IModelElement modelElement, ValueProperty property, SapphireRenderingContext context, Text text) {
        super(modelElement, (ModelProperty)property, context, (Control)text);
    }

    protected void initialize(IModelElement modelElement, ModelProperty property, SapphireRenderingContext context, Control control) {
        super.initialize(modelElement, property, context, control);
        this.onTextContentModifyTask = new DelayedTasksExecutor.Task(){

            public int getPriority() {
                return 100;
            }

            public void run() {
                TextFieldBinding.this.updateModel();
                TextFieldBinding.this.updateTargetAttributes();
            }
        };
        this.text = (Text)control;
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextFieldBinding.this.updateTextContent(TextFieldBinding.this.text.getText());
            }
        });
    }

    protected void updateTextContent(String textContent) {
        this.textContent = textContent;
        DelayedTasksExecutor.schedule(this.onTextContentModifyTask);
    }

    protected void doUpdateModel() {
        if (!this.text.isDisposed() && (this.text.getStyle() & 8) == 0) {
            ((ValueProperty)this.getProperty()).invokeSetterMethod((Object)this.getModelElement(), (Object)this.textContent);
        }
    }

    protected void doUpdateTarget() {
        Value value = (Value)this.getPropertyValue();
        String existingValue = this.text.getText();
        if (value == null) {
            if (!existingValue.equals("")) {
                this.text.setText("");
            }
        } else {
            String newValue = value.getText(false);
            if (!existingValue.equals(newValue)) {
                this.text.setText(newValue == null ? "" : newValue);
            }
        }
    }
}

