/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.ui.SapphireCommands;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.BrowseHandler;
import org.eclipse.sapphire.ui.renderers.swt.BrowseCommandHandler;
import org.eclipse.sapphire.ui.renderers.swt.DefaultListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseableTextCellEditor
extends TextCellEditor {
    private final SapphirePart part;
    private final StructuredViewer viewer;
    private final DefaultListPropertyEditorRenderer.SelectionProvider selectionProvider;
    private Composite topComposite;
    private Composite innerComposite;
    private Text text;
    private Label button;
    private List<BrowseHandler> browseHandlers;
    private SapphireRenderingContext context;
    private boolean disableFocusLostHandler;
    private int maxWidth = -1;
    private boolean isDefaultValue;
    private ISelection selectionPriorToActivation;

    public BrowseableTextCellEditor(SapphirePart part, StructuredViewer parent, DefaultListPropertyEditorRenderer.SelectionProvider selectionProvider, int style) {
        this.part = part;
        this.viewer = parent;
        this.selectionProvider = selectionProvider;
        this.browseHandlers = Collections.emptyList();
        this.setStyle(style);
        this.create((Composite)parent.getControl());
    }

    public void setBrowseHandlers(List<BrowseHandler> browseHandlers) {
        this.browseHandlers = browseHandlers != null ? browseHandlers : Collections.emptyList();
    }

    public void setContext(SapphireRenderingContext context) {
        this.context = context;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        if (maxWidth == -1) {
            this.innerComposite.setLayoutData((Object)SwtUtil.gdfill());
        } else {
            this.innerComposite.setLayoutData((Object)SwtUtil.gdwhint(SwtUtil.gd(), maxWidth));
        }
    }

    public void setHorizonalIndent(int horizontalIndent) {
        ((GridLayout)this.topComposite.getLayout()).marginLeft = horizontalIndent;
    }

    protected Object doGetValue() {
        if (this.isDefaultValue) {
            return null;
        }
        return super.doGetValue();
    }

    protected void doSetValue(Object value) {
        Value val = (Value)value;
        String str = val.getText(true);
        super.doSetValue((Object)(str == null ? "" : str));
        this.isDefaultValue = val.getText(false) == null && val.getDefaultContent() != null;
    }

    protected Control createControl(Composite parent) {
        int style = this.getStyle();
        this.topComposite = new Composite(parent, 0);
        this.topComposite.setBackground(parent.getBackground());
        this.topComposite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 0));
        this.innerComposite = new Composite(this.topComposite, style);
        this.innerComposite.setLayoutData((Object)SwtUtil.gdfill());
        this.innerComposite.setLayout((Layout)new CustomLayout());
        this.innerComposite.setBackground(parent.getBackground());
        Label spacer = new Label(this.topComposite, 0);
        spacer.setText("");
        spacer.setLayoutData((Object)SwtUtil.gd());
        this.setStyle(0);
        this.text = (Text)super.createControl(this.innerComposite);
        this.setStyle(style);
        SapphireCommands.configurePropertyEditorContext((Control)this.text);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BrowseableTextCellEditor.this.isDefaultValue = false;
            }
        });
        this.button = new Label(this.innerComposite, 0);
        this.button.setBackground(parent.getBackground());
        this.button.setImage(this.part.getImageCache().getImage(SapphireImageCache.ACTION_BROWSE_MINI));
        final Cursor browseButtonCursor = new Cursor((Device)this.button.getDisplay(), 21);
        this.button.setCursor(browseButtonCursor);
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                browseButtonCursor.dispose();
            }
        });
        this.button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                BrowseableTextCellEditor.this.handleBrowseEvent();
            }
        });
        AbstractHandler browseCommandHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                BrowseableTextCellEditor.this.handleBrowseEvent();
                return null;
            }
        };
        SapphireCommands.attachBrowseHandler((Control)this.text, (IHandler)browseCommandHandler);
        return this.topComposite;
    }

    public void activate() {
        this.selectionPriorToActivation = this.viewer.getSelection();
        if (this.selectionProvider != null) {
            this.selectionProvider.setFakeSelection(this.selectionPriorToActivation);
        }
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        super.activate();
        this.topComposite.layout(true, true);
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData data = new CellEditor.LayoutData();
        data.minimumWidth = 150;
        return data;
    }

    protected void focusLost() {
        if (!this.disableFocusLostHandler) {
            this.disableFocusLostHandler = true;
            super.focusLost();
            this.disableFocusLostHandler = false;
            this.viewer.setSelection(this.selectionPriorToActivation);
            if (this.selectionProvider != null) {
                this.selectionProvider.setFakeSelection(null);
            }
            this.selectionPriorToActivation = null;
        }
    }

    private void handleBrowseEvent() {
        if (this.browseHandlers != null && !this.browseHandlers.isEmpty()) {
            this.disableFocusLostHandler = true;
            BrowseCommandHandler browseCommandHandler = new BrowseCommandHandler(this.context, this.browseHandlers){

                protected Rectangle getInvokerBounds() {
                    Rectangle bounds = BrowseableTextCellEditor.this.button.getBounds();
                    Point convertedCoordinates = BrowseableTextCellEditor.this.text.getParent().toDisplay(bounds.x, bounds.y);
                    bounds.x = convertedCoordinates.x;
                    bounds.y = convertedCoordinates.y;
                    return bounds;
                }

                protected void handleBrowseCompleted(String text) {
                    BrowseableTextCellEditor.this.disableFocusLostHandler = false;
                    if (text != null) {
                        BrowseableTextCellEditor.this.text.setText(text);
                        BrowseableTextCellEditor.this.focusLost();
                    }
                }

                protected void handleBrowseCanceled() {
                    BrowseableTextCellEditor.this.disableFocusLostHandler = false;
                }
            };
            browseCommandHandler.execute(null);
        }
    }

    private final class CustomLayout
    extends Layout {
        private final Point ZERO_SIZE = new Point(0, 0);

        private CustomLayout() {
        }

        public void layout(Composite editor, boolean force) {
            int constraintedBoundsWidth;
            Rectangle bounds = editor.getClientArea();
            Point size = this.computeButtonSize(force);
            int n = constraintedBoundsWidth = BrowseableTextCellEditor.this.maxWidth != -1 ? Math.min(bounds.width, BrowseableTextCellEditor.this.maxWidth) : bounds.width;
            if (BrowseableTextCellEditor.this.text != null) {
                BrowseableTextCellEditor.this.text.setBounds(0, 0, constraintedBoundsWidth - size.x, bounds.height);
            }
            BrowseableTextCellEditor.this.button.setBounds(constraintedBoundsWidth - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = BrowseableTextCellEditor.this.text.computeSize(-1, -1, force);
            Point buttonSize = this.computeButtonSize(force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }

        private Point computeButtonSize(boolean force) {
            if (BrowseableTextCellEditor.this.browseHandlers.isEmpty()) {
                return this.ZERO_SIZE;
            }
            return BrowseableTextCellEditor.this.button.computeSize(-1, -1, force);
        }
    }
}

