/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderImpl;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.ColumnSortComparator;
import org.eclipse.sapphire.ui.renderers.swt.ListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CheckBoxListPropertyEditorRenderer
extends ListPropertyEditorRenderer {
    private Table table;
    private CheckboxTableViewer tableViewer;
    private ModelElementType memberType;
    private ValueProperty memberProperty;

    public CheckBoxListPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        ModelProperty prop;
        SapphirePropertyEditor part = this.getPart();
        IModelElement element = part.getModelElement();
        ListProperty listProperty = (ListProperty)part.getProperty();
        this.memberType = listProperty.getType();
        List allMemberProperties = this.memberType.getProperties();
        if (allMemberProperties.size() == 1) {
            prop = (ModelProperty)allMemberProperties.get(0);
            if (!(prop instanceof ValueProperty)) {
                throw new IllegalStateException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.memberProperty = (ValueProperty)prop;
        final PossibleValuesProviderImpl possibleValuesProvider = element.service().getPossibleValuesProvider(this.memberProperty);
        boolean showLabelAbove = part.getRenderingHint("show.label.above", false);
        boolean showLabelInline = part.getRenderingHint("show.label", !showLabelAbove);
        Label label = null;
        int baseIndent = part.getLeftMarginHint() + 9;
        if (showLabelInline || showLabelAbove) {
            label = new Label(parent, 0);
            label.setText(String.valueOf(listProperty.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
            label.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.hspan(SwtUtil.valign(SwtUtil.gd(), 128), showLabelAbove ? 2 : 1), baseIndent));
            this.context.adapt((Control)label);
        }
        this.setSpanBothColumns(!showLabelInline);
        Composite mainComposite = this.createMainComposite(parent);
        mainComposite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(mainComposite);
        decorator.getControl().setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 128));
        Composite tableComposite = new Composite(mainComposite, 0);
        tableComposite.setLayoutData((Object)SwtUtil.gdwhint(SwtUtil.gdfill(), 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)67584);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(this.memberProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 100, true));
        this.context.adapt((Control)mainComposite);
        decorator.addEditorControl((Control)mainComposite);
        final ColumnSortComparator comparator = new ColumnSortComparator(){

            protected String convertToString(Object obj) {
                return ((Entry)obj).value;
            }
        };
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                Entry entry;
                Entry selection = (Entry)((IStructuredSelection)CheckBoxListPropertyEditorRenderer.this.tableViewer.getSelection()).getFirstElement();
                ArrayList<Entry> entries = new ArrayList<Entry>();
                HashSet<String> checked = new HashSet<String>();
                for (IModelElement element : CheckBoxListPropertyEditorRenderer.this.getList()) {
                    String value = CheckBoxListPropertyEditorRenderer.this.readMemberProperty(element);
                    if (selection != null && selection.value.equals(value)) {
                        entry = selection;
                        entry.element = element;
                        selection = null;
                    } else {
                        entry = new Entry(value, element);
                    }
                    entries.add(entry);
                    checked.add(value);
                }
                SortedSet possibleValues = null;
                try {
                    possibleValues = possibleValuesProvider.getPossibleValues();
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
                if (possibleValues != null) {
                    for (String value : possibleValues) {
                        if (checked.contains(value)) continue;
                        if (selection != null && selection.value.equals(value)) {
                            entry = selection;
                            entry.element = null;
                            selection = null;
                        } else {
                            entry = new Entry(value, null);
                        }
                        entries.add(entry);
                    }
                }
                Collections.sort(entries, comparator);
                return entries.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Entry)element).text();
            }

            public Image getImage(Object element) {
                return ((Entry)element).image();
            }

            public Color getForeground(Object element) {
                return ((Entry)element).foreground();
            }
        };
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        ICheckStateProvider checkStateProvider = new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return ((Entry)element).selected();
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        };
        this.tableViewer.setCheckStateProvider(checkStateProvider);
        SwtUtil.makeTableSortable((TableViewer)this.tableViewer, Collections.singletonMap(column, comparator));
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CheckBoxListPropertyEditorRenderer.this.handleCheckStateChangedEvent(event);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                CheckBoxListPropertyEditorRenderer.this.handleDoubleClickEvent(event);
            }
        });
        this.tableViewer.setInput(new Object());
        this.addControl((Control)this.table);
    }

    protected boolean canExpandVertically() {
        return true;
    }

    protected void handleFocusReceivedEvent() {
        this.table.setFocus();
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.tableViewer.refresh();
    }

    protected void handleListElementChangedEvent(ModelPropertyChangeEvent event) {
        super.handleListElementChangedEvent(event);
        this.tableViewer.refresh();
    }

    private void handleCheckStateChangedEvent(CheckStateChangedEvent event) {
        Entry entry = (Entry)event.getElement();
        entry.flip();
    }

    private void handleDoubleClickEvent(MouseEvent event) {
        Entry entry = null;
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getBounds().contains(event.x, event.y)) {
                entry = (Entry)item.getData();
                break;
            }
            ++n2;
        }
        if (entry != null) {
            entry.flip();
        }
    }

    private ModelElementType getMemberType() {
        return this.memberType;
    }

    private ValueProperty getMemberProperty() {
        return this.memberProperty;
    }

    private String readMemberProperty(IModelElement element) {
        String text = element.service().read(this.memberProperty).getText();
        return text == null ? "" : text;
    }

    public final class Entry {
        private String value;
        private IModelElement element;

        public Entry(String value, IModelElement element) {
            this.value = value;
            this.element = element;
        }

        public String text() {
            String text = this.value;
            if (text.length() == 0) {
                text = Resources.emptyIndicator;
            }
            return text;
        }

        public Image image() {
            Image image;
            if (this.element == null) {
                image = CheckBoxListPropertyEditorRenderer.this.getPart().getImageCache().getImage(CheckBoxListPropertyEditorRenderer.this.getMemberType());
            } else {
                IStatus st = this.element.service().read(CheckBoxListPropertyEditorRenderer.this.getMemberProperty()).validate();
                image = CheckBoxListPropertyEditorRenderer.this.getPart().getImageCache().getImage(CheckBoxListPropertyEditorRenderer.this.getMemberType(), st.getSeverity());
            }
            return image;
        }

        public Color foreground() {
            Color color = null;
            if (this.value.length() == 0) {
                color = Display.getCurrent().getSystemColor(16);
            }
            return color;
        }

        public boolean selected() {
            return this.element != null;
        }

        public void flip() {
            if (this.element == null) {
                this.element = CheckBoxListPropertyEditorRenderer.this.getList().addNewElement();
                this.element.service().write(CheckBoxListPropertyEditorRenderer.this.getMemberProperty(), (Object)this.value);
            } else {
                IModelElement el = this.element;
                this.element = null;
                ((IRemovable)el).remove();
            }
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return true;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new CheckBoxListPropertyEditorRenderer(context, part);
        }
    }

    private static final class Resources
    extends NLS {
        public static String emptyIndicator;

        static {
            Resources.initializeMessages((String)CheckBoxListPropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

