/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.ui.SapphireCommands;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.AuxTextProvider;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class PropertyEditorRenderer {
    protected final SapphireRenderingContext context;
    private final SapphirePropertyEditor part;
    protected PropertyEditorAssistDecorator decorator;
    private Label auxTextControl;
    private AuxTextProvider auxTextProvider;
    private final Set<Control> controls;
    private boolean spanBothColumns;
    protected AbstractBinding binding;

    public PropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        this.context = context;
        this.part = part;
        this.controls = new HashSet<Control>();
        this.spanBothColumns = false;
    }

    public SapphireRenderingContext getUiContext() {
        return this.context;
    }

    public SapphirePropertyEditor getPart() {
        return this.part;
    }

    public IModelElement getModelElement() {
        return this.part.getModelElement();
    }

    public ModelProperty getProperty() {
        return this.part.getProperty();
    }

    public SapphireImageCache getImageCache() {
        return this.part.getImageCache();
    }

    protected boolean canExpandVertically() {
        return false;
    }

    protected final boolean getSpanBothColumns() {
        return this.spanBothColumns;
    }

    protected final void setSpanBothColumns(boolean spanBothColumns) {
        this.spanBothColumns = spanBothColumns;
    }

    public final void create(Composite parent) {
        this.createContents(parent);
        String auxText = this.part.getRenderingHint("aux.text", null);
        Class auxTextProviderClass = this.part.getRenderingHint("aux.text.provider", null);
        if (auxTextProviderClass != null) {
            try {
                this.auxTextProvider = (AuxTextProvider)auxTextProviderClass.newInstance();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        if (auxText != null || this.auxTextProvider != null) {
            if (!this.spanBothColumns) {
                Label placeholder = new Label(parent, 0);
                placeholder.setLayoutData((Object)SwtUtil.gd());
                placeholder.setText("");
                this.context.adapt((Control)placeholder);
            }
            int hindent = this.part.getLeftMarginHint() + 9;
            this.auxTextControl = new Label(parent, 0);
            this.auxTextControl.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.hspan(SwtUtil.gdhfill(), this.spanBothColumns ? 2 : 1), hindent));
            this.auxTextControl.setForeground(parent.getDisplay().getSystemColor(16));
            this.addControl((Control)this.auxTextControl);
            if (auxText != null) {
                this.auxTextControl.setText("(" + auxText + ")");
            }
        }
        final SapphirePropertyEditor part = this.getPart();
        final IModelElement modelElement = this.getModelElement();
        final ModelProperty property = this.getProperty();
        final ModelPropertyListener propertyChangeListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                PropertyEditorRenderer.this.handlePropertyChangedEvent();
            }
        };
        modelElement.addListener(propertyChangeListener, property.getName());
        this.handlePropertyChangedEvent();
        if (this.binding != null) {
            this.binding.setModelElement(this.getModelElement());
        }
        final SapphirePartListener partListener = new SapphirePartListener(){

            public void handleFocusReceivedEvent(SapphirePartEvent event) {
                PropertyEditorRenderer.this.handleFocusReceivedEvent();
            }
        };
        part.addListener(partListener);
        DisposeListener disposeListener = new DisposeListener(){
            boolean executed = false;

            public void widgetDisposed(DisposeEvent event) {
                if (!this.executed) {
                    part.removeListener(partListener);
                    modelElement.removeListener(propertyChangeListener, property.getName());
                    PropertyEditorRenderer.this.handleDisposeEvent();
                    this.executed = true;
                }
            }
        };
        for (Control c : this.controls) {
            this.context.setHelp(c, modelElement, property);
            c.addDisposeListener(disposeListener);
        }
    }

    protected abstract void createContents(Composite var1);

    protected final Composite createMainComposite(Composite parent) {
        GridData gd;
        List<SapphirePropertyEditor> auxPropertyEditors = this.part.getAuxPropertyEditors();
        int count = auxPropertyEditors.size();
        if (this.canExpandVertically()) {
            boolean expandVertically = this.part.getRenderingHint("expand.vertically", false);
            int heightHint = this.part.getRenderingHint("height", 10) * 15;
            gd = expandVertically ? SwtUtil.gdfill() : SwtUtil.gdhhint(SwtUtil.gdhfill(), heightHint);
        } else {
            gd = SwtUtil.gdhfill();
        }
        if (this.spanBothColumns) {
            gd = SwtUtil.gdhindent(SwtUtil.hspan(gd, 2), this.part.getLeftMarginHint());
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)gd);
        this.context.adapt((Control)composite);
        if (count == 0) {
            return composite;
        }
        composite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(count + 1, 0, 0), 5));
        Composite mainPropertyEditorComposite = new Composite(composite, 0);
        mainPropertyEditorComposite.setLayoutData((Object)SwtUtil.valign(SwtUtil.gdfill(), 0x1000000));
        this.context.adapt((Control)mainPropertyEditorComposite);
        for (SapphirePropertyEditor auxPropertyEditor : auxPropertyEditors) {
            Composite auxPropertyEditorComposite = new Composite(composite, 0);
            auxPropertyEditorComposite.setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 0x1000000));
            auxPropertyEditorComposite.setLayout((Layout)SwtUtil.glayout(2, 0, 0));
            this.context.adapt((Control)auxPropertyEditorComposite);
            auxPropertyEditor.render(new SapphireRenderingContext(auxPropertyEditor, this.context, auxPropertyEditorComposite));
        }
        return mainPropertyEditorComposite;
    }

    protected final PropertyEditorAssistDecorator createDecorator(Composite parent) {
        this.decorator = new PropertyEditorAssistDecorator(this.part, this.context, parent);
        return this.decorator;
    }

    protected final void addControl(Control control) {
        this.controls.add(control);
        control.setData("property", (Object)this.getProperty());
        SapphireCommands.configurePropertyEditorContext(control);
    }

    protected void handlePropertyChangedEvent() {
        boolean enabled = this.getModelElement().isPropertyEnabled(this.getProperty());
        for (Control control : this.controls) {
            if (control.isDisposed()) continue;
            control.setEnabled(enabled);
        }
        if (this.decorator != null) {
            this.decorator.refresh();
        }
        if (this.auxTextProvider != null) {
            String auxText = this.auxTextProvider.getAuxText(this.getModelElement(), this.getProperty());
            this.auxTextControl.setText("(" + auxText + ")");
        }
    }

    protected void handleFocusReceivedEvent() {
    }

    protected void handleDisposeEvent() {
    }
}

