/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartContext;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireConditionManager {
    private final SapphirePart part;
    private final SapphireCondition condition;
    private final List<String> conditionDependencies;
    private final ModelPropertyListener conditionUpdateListener;
    private boolean conditionState;
    private final Runnable onConditionChangeCallback;

    public static SapphireConditionManager create(SapphirePart part, Class<?> conditionClass, String conditionParameter, Runnable onConditionChangeCallback) {
        try {
            SapphireCondition condition = (SapphireCondition)conditionClass.newInstance();
            condition.init(new SapphirePartContext(part), conditionParameter);
            return new SapphireConditionManager(part, condition, onConditionChangeCallback);
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
            return null;
        }
    }

    private SapphireConditionManager(SapphirePart part, SapphireCondition condition, Runnable onConditionChangeCallback) {
        this.part = part;
        this.condition = condition;
        this.conditionDependencies = this.condition.getDependencies();
        this.conditionState = this.condition.evaluate();
        this.onConditionChangeCallback = onConditionChangeCallback;
        if (this.conditionDependencies != null && this.conditionDependencies.size() > 0) {
            this.conditionUpdateListener = new ModelPropertyListener(){

                public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                    SapphireConditionManager.this.updateConditionState();
                }
            };
            IModelElement contextModelElement = part.getModelElement();
            for (String dependency : this.conditionDependencies) {
                contextModelElement.addListener(this.conditionUpdateListener, dependency);
            }
        } else {
            this.conditionUpdateListener = null;
        }
    }

    public boolean getConditionState() {
        return this.conditionState;
    }

    private void updateConditionState() {
        boolean newConditionState;
        try {
            newConditionState = this.condition.evaluate();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
            return;
        }
        if (this.conditionState != newConditionState) {
            this.conditionState = newConditionState;
            this.onConditionChangeCallback.run();
        }
    }

    public void dispose() {
        if (this.conditionUpdateListener != null) {
            IModelElement modelElement = this.part.getModelElement();
            for (String dependency : this.conditionDependencies) {
                modelElement.removeListener(this.conditionUpdateListener, dependency);
            }
        }
    }
}

