/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.modeling.LabelTransformer;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.ui.SapphirePageBook;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireElementPropertyCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireLabelDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SapphireElementPropertyComposite
extends SapphirePageBook {
    private IModelElement modelElementForChildParts;
    private ElementProperty property;
    private ISapphireCompositeDef elementAbsentPageDef;

    protected void init() {
        ISapphireElementPropertyCompositeDef def = (ISapphireElementPropertyCompositeDef)this.definition;
        this.property = (ElementProperty)this.resolve(def.getConditionalProperty().getText());
        this.elementAbsentPageDef = this.createElementAbsentPageDef();
        super.init();
        this.setExposePageValidationState(true);
        this.updateCurrentPage(true);
    }

    public ElementProperty getConditionalProperty() {
        return this.property;
    }

    public void render(final SapphireRenderingContext context) {
        ISapphireElementPropertyCompositeDef def = (ISapphireElementPropertyCompositeDef)this.definition;
        Composite composite = new Composite(context.getComposite(), 0);
        composite.setLayoutData((Object)SwtUtil.hspan(SwtUtil.gdhfill(), 2));
        composite.setLayout((Layout)SwtUtil.glayout(1, 0, 0));
        context.adapt((Control)composite);
        final Button masterCheckBox = new Button(composite, 32);
        masterCheckBox.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.hspan(SwtUtil.gdhfill(), 2), 10));
        masterCheckBox.setText(LabelTransformer.transform((String)def.getConditionalLabel().getLocalizedText(), (CapitalizationType)CapitalizationType.FIRST_WORD_ONLY, (boolean)true));
        context.adapt((Control)masterCheckBox);
        Composite separatorComposite = new Composite(composite, 0);
        separatorComposite.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.hspan(SwtUtil.gdhfill(), 2), 10));
        separatorComposite.setLayout((Layout)SwtUtil.glayout(1, 0, 5));
        context.adapt((Control)separatorComposite);
        Label separator = new Label(separatorComposite, 258);
        separator.setLayoutData((Object)SwtUtil.gdhfill());
        super.render(new SapphireRenderingContext(this, context, composite));
        final IModelElement modelElement = this.getModelElement();
        final ElementProperty property = this.property;
        final ModelPropertyListener modelPropertyListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                IModelElement subModelElement = (IModelElement)property.invokeGetterMethod((Object)modelElement);
                masterCheckBox.setSelection(subModelElement != null);
                masterCheckBox.setEnabled(modelElement.isPropertyEnabled((ModelProperty)property));
                if (subModelElement != null) {
                    context.setHelp((Control)masterCheckBox, subModelElement, (ModelProperty)property);
                }
            }
        };
        modelPropertyListener.handlePropertyChangedEvent(null);
        modelElement.addListener(modelPropertyListener, property.getName());
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                modelElement.removeListener(modelPropertyListener, property.getName());
            }
        });
        masterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    try {
                        if (masterCheckBox.getSelection()) {
                            property.invokeGetterMethod((Object)modelElement, true);
                        } else {
                            IRemovable subModelElement = (IRemovable)property.invokeGetterMethod((Object)modelElement);
                            if (subModelElement != null) {
                                subModelElement.remove();
                            }
                        }
                    }
                    catch (Exception e) {
                        EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                        if (editFailedException != null) break block5;
                        SapphireUiFrameworkPlugin.log(e);
                    }
                }
            }
        });
    }

    protected void handleModelElementChange(ModelPropertyChangeEvent event) {
        super.handleModelElementChange(event);
        if (event.getProperty().getName().equals(this.property.getName())) {
            this.updateCurrentPage(false);
        }
    }

    protected Object parsePageKey(String pageKeyString) {
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.getModel();
        Class<?> cl = rootdef.resolveClass(pageKeyString);
        return SapphirePageBook.ClassBasedKey.create(cl);
    }

    private void updateCurrentPage(boolean force) {
        IModelElement modelElement = this.getModelElement();
        IModelElement subModelElement = (IModelElement)this.property.invokeGetterMethod((Object)modelElement);
        if (force || this.modelElementForChildParts != subModelElement) {
            this.modelElementForChildParts = subModelElement;
            if (this.modelElementForChildParts != null) {
                this.changePage(this.modelElementForChildParts, SapphirePageBook.ClassBasedKey.create(this.modelElementForChildParts));
            } else {
                this.changePage(modelElement, this.elementAbsentPageDef);
            }
        }
    }

    private ISapphireCompositeDef createElementAbsentPageDef() {
        ISapphireUiDef root = SapphireUiDefFactory.create();
        ISapphireCompositeDef composite = (ISapphireCompositeDef)root.getCompositeDefs().addNewElement();
        ISapphireLabelDef label = (ISapphireLabelDef)composite.getContent().addNewElement(ISapphireLabelDef.TYPE);
        label.setText(Resources.noAdditionalPropertiesMessage);
        return composite;
    }

    public boolean setFocus(ModelPath path) {
        IModelElement element;
        String propertyName;
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.PropertySegment && (propertyName = ((ModelPath.PropertySegment)head).getPropertyName()).equals(this.property.getName()) && (element = this.getModelElement()).isPropertyEnabled((ModelProperty)this.property) && element.service().read(this.property) != null) {
            super.setFocus(path.tail());
        }
        return false;
    }

    private static final class Resources
    extends NLS {
        public static String noAdditionalPropertiesMessage;

        static {
            Resources.initializeMessages((String)SapphireElementPropertyComposite.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

