/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionsCommandBridge {
    private final Control control;
    private final List<ActionGroup> actions;
    private final IHandlerService handlerService;
    private final List<IHandlerActivation> handlerActivations;

    public ActionsCommandBridge(Control control) {
        this.control = control;
        this.actions = new ArrayList<ActionGroup>();
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.handlerActivations = new ArrayList<IHandlerActivation>();
        this.control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                ActionsCommandBridge.this.activateHandlers();
            }

            public void focusLost(FocusEvent event) {
                ActionsCommandBridge.this.deactivateHandlers();
            }
        });
    }

    public void setActions(List<ActionGroup> actions) {
        this.actions.clear();
        this.actions.addAll(actions);
        if (this.control.isFocusControl()) {
            this.activateHandlers();
        }
    }

    private void activateHandlers() {
        this.deactivateHandlers();
        for (ActionGroup group : this.actions) {
            for (final Action action : group.getActions()) {
                String commandId = action.getCommandId();
                if (commandId == null) continue;
                AbstractHandler handler = new AbstractHandler(){

                    public Object execute(ExecutionEvent event) {
                        action.execute(ActionsCommandBridge.this.control.getShell());
                        return null;
                    }
                };
                IHandlerActivation activation = this.handlerService.activateHandler(commandId, (IHandler)handler);
                this.handlerActivations.add(activation);
            }
        }
    }

    private void deactivateHandlers() {
        for (IHandlerActivation activation : this.handlerActivations) {
            this.handlerService.deactivateHandler(activation);
        }
        this.handlerActivations.clear();
    }
}

