/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.internal.PluginUtil;
import org.eclipse.sapphire.ui.assist.JumpHandler;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

public final class JumpHandlersExtensionPoint {
    private static final String EL_JUMP_HANDLER = "jump-handler";
    private static final String ATTR_CLASS = "class";
    private static final Comparator<JumpHandler> COMPARATOR = new Comparator<JumpHandler>(){

        @Override
        public int compare(JumpHandler x, JumpHandler y) {
            int res = x.getPriority() - y.getPriority();
            if (res == 0) {
                res = x.getClass().getName().compareTo(y.getClass().getName());
            }
            return res;
        }
    };
    private static List<JumpHandler> jumpHandlers = null;

    public static JumpHandler getJumpHandler(ValueProperty property) {
        JumpHandlersExtensionPoint.initialize();
        ArrayList<JumpHandler> candidates = new ArrayList<JumpHandler>();
        for (JumpHandler jumpHandler : jumpHandlers) {
            try {
                if (!jumpHandler.isApplicable(property)) continue;
                candidates.add(jumpHandler);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (JumpHandler)candidates.get(0);
        }
        Collections.sort(candidates, COMPARATOR);
        return (JumpHandler)candidates.get(candidates.size() - 1);
    }

    private static synchronized void initialize() {
        if (jumpHandlers == null) {
            jumpHandlers = new ArrayList<JumpHandler>();
            for (IConfigurationElement el : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"org.eclipse.sapphire.ui", (String)"jumpHandlers"))) {
                String pluginId = el.getNamespaceIdentifier();
                if (!el.getName().equals(EL_JUMP_HANDLER)) continue;
                try {
                    String clname = PluginUtil.findRequiredAttribute((IConfigurationElement)el, (String)ATTR_CLASS);
                    JumpHandler jumpHandler = (JumpHandler)PluginUtil.instantiate((String)pluginId, (String)clname, JumpHandler.class);
                    if (jumpHandler == null) continue;
                    jumpHandlers.add(jumpHandler);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
            }
        }
    }
}

