/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.java.JavaTypeName;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.JumpHandler;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.widgets.Shell;

public final class JavaClassValueJumpHandler
extends JumpHandler {
    public boolean isApplicable(ValueProperty property) {
        return property.isOfType(JavaTypeName.class);
    }

    public boolean canLocateJumpTarget(SapphirePart part, SapphireRenderingContext context, IModelElement modelElement, ValueProperty property) {
        String typeName = ((Value)property.invokeGetterMethod((Object)modelElement)).getText(true);
        return typeName != null && JavaClassValueJumpHandler.getType(typeName, this.getProject(modelElement)) != null;
    }

    public void jump(SapphirePart part, SapphireRenderingContext context, IModelElement modelElement, ValueProperty property) {
        try {
            String typeName = ((Value)property.invokeGetterMethod((Object)modelElement)).getText(true);
            if (typeName != null) {
                IType type = JavaClassValueJumpHandler.getType(typeName, this.getProject(modelElement));
                if (type != null) {
                    JavaUI.openInEditor((IJavaElement)type);
                } else {
                    String message = NLS.bind((String)Resources.couldNotFindTypeDialogMessage, (Object)typeName);
                    MessageDialog.openInformation((Shell)context.getShell(), (String)Resources.couldNotFindTypeDialogTitle, (String)message);
                }
            }
        }
        catch (CoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    private IProject getProject(IModelElement modelElement) {
        IProject project = (IProject)Platform.getAdapterManager().loadAdapter((Object)modelElement.getModel(), IProject.class.getName());
        if (project == null) {
            project = modelElement.getModel().getEclipseProject();
        }
        return project;
    }

    private static IType getType(String fullyQualifiedType, IProject project) {
        assert (fullyQualifiedType != null) : "Fully qualified type should not be null.";
        if (fullyQualifiedType.trim().length() == 0 || fullyQualifiedType.startsWith(".") || fullyQualifiedType.endsWith(".")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        IType type = null;
        try {
            type = javaProject.findType(fullyQualifiedType);
            if (type != null && (!type.exists() || type.isAnonymous())) {
                type = null;
            }
        }
        catch (JavaModelException ce) {
            SapphireUiFrameworkPlugin.log(ce);
        }
        return type;
    }

    private static final class Resources
    extends NLS {
        public static String couldNotFindTypeDialogTitle;
        public static String couldNotFindTypeDialogMessage;

        static {
            Resources.initializeMessages((String)JavaClassValueJumpHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

