/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.util.SortedSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderImpl;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.BrowseHandler;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public final class PossibleValuesProviderBrowseHandler
extends BrowseHandler {
    public String browse(SapphireRenderingContext context) {
        ValueProperty property = this.getProperty();
        PossibleValuesProviderImpl valuesProvider = this.getModelElement().service().getPossibleValuesProvider(property);
        if (valuesProvider != null) {
            SortedSet valuesList = valuesProvider.getPossibleValues();
            Object[] valuesArray = valuesList.toArray(new String[valuesList.size()]);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(context.getShell(), (ILabelProvider)new LabelProvider());
            dialog.setElements(valuesArray);
            dialog.setMultipleSelection(false);
            dialog.setHelpAvailable(false);
            dialog.setTitle(property.getLabel(false, CapitalizationType.TITLE_STYLE, false));
            dialog.setMessage(this.createBrowseDialogMessage(property.getLabel(true, CapitalizationType.NO_CAPS, false)));
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length == 1) {
                return (String)result[0];
            }
        }
        return null;
    }
}

