/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public final class ProblemsAssistContributor
extends PropertyEditorAssistContributor {
    private final IStatus status;

    public ProblemsAssistContributor(IStatus status) {
        this.setId("System.ProblemsContributor");
        this.setPriority(210);
        this.status = status;
    }

    public void contribute(PropertyEditorAssistContext context) {
        if (this.status.isMultiStatus()) {
            IStatus[] iStatusArray = this.status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                ProblemsAssistContributor.contribute(context, child);
                ++n2;
            }
        } else {
            ProblemsAssistContributor.contribute(context, this.status);
        }
    }

    private static void contribute(PropertyEditorAssistContext context, IStatus status) {
        int valResultSeverity = status.getSeverity();
        String imageKey = null;
        Image image = null;
        if (valResultSeverity == 4) {
            imageKey = "error";
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        } else if (valResultSeverity == 2) {
            imageKey = "error";
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (imageKey != null) {
            PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
            contribution.setText("<li style=\"image\" value=\"" + imageKey + "\">" + ProblemsAssistContributor.escapeForXml(status.getMessage()) + "</li>");
            contribution.setImage(imageKey, image);
            PropertyEditorAssistSection section = context.getSection("problems");
            section.addContribution(contribution);
        }
    }
}

