/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.build.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sapphire.ui.build.internal.StringResourcesExtractor;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

public final class StringResourcesExtractorBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Extracting localizable resources...", 100);
        try {
            IProject project = this.getProject();
            ICommand command = this.getCommand();
            Map arguments = command.getArguments();
            String input = (String)arguments.get("input");
            if (input == null) {
                throw new IllegalStateException();
            }
            IFolder inputFolder = project.getFolder(input);
            if (!inputFolder.exists()) {
                throw new IllegalStateException();
            }
            String output = (String)arguments.get("output");
            if (output == null) {
                throw new IllegalStateException();
            }
            IFolder outputFolder = project.getFolder(output);
            IResourceDelta delta = this.getDelta(project);
            final HashSet inputFilesAddedOrModified = new HashSet();
            final HashSet inputFilesRemoved = new HashSet();
            if (delta == null) {
                inputFolder.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) {
                        if (resource.getType() == 2) {
                            return true;
                        }
                        if (resource.getFileExtension().toLowerCase().equals("sdef")) {
                            inputFilesAddedOrModified.add((IFile)resource);
                        }
                        return false;
                    }
                });
            } else if ((delta = delta.findMember(inputFolder.getProjectRelativePath())) != null) {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 2) {
                            return true;
                        }
                        if (resource.getFileExtension().toLowerCase().equals("sdef")) {
                            if (delta.getKind() == 2) {
                                inputFilesRemoved.add((IFile)resource);
                            } else {
                                inputFilesAddedOrModified.add((IFile)resource);
                            }
                        }
                        return false;
                    }
                });
            }
            monitor.worked(10);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            int totalFilesToProcess = inputFilesRemoved.size() + inputFilesAddedOrModified.size();
            if (totalFilesToProcess == 0) {
                monitor.worked(90);
            } else {
                SubProgressMonitor processingProgressMonitor = new SubProgressMonitor(monitor, 90);
                processingProgressMonitor.beginTask("", totalFilesToProcess);
                for (IFile file : inputFilesRemoved) {
                    IFile resourcesFile = StringResourcesExtractorBuilder.getResourceFile(inputFolder, file, outputFolder);
                    if (resourcesFile.exists()) {
                        resourcesFile.delete(true, null);
                    }
                    processingProgressMonitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                for (IFile file : inputFilesAddedOrModified) {
                    try {
                        String resourcesFileContent;
                        InputStream in = file.getContents();
                        try {
                            InputStreamReader r = new InputStreamReader(in);
                            resourcesFileContent = StringResourcesExtractor.extract(r);
                        }
                        catch (Throwable throwable) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        if (resourcesFileContent != null) {
                            byte[] bytes = resourcesFileContent.getBytes();
                            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                            IFile resourcesFile = StringResourcesExtractorBuilder.getResourceFile(inputFolder, file, outputFolder);
                            if (resourcesFile.exists()) {
                                resourcesFile.setContents((InputStream)stream, 1, null);
                            } else {
                                StringResourcesExtractorBuilder.create(resourcesFile.getParent());
                                resourcesFile.create((InputStream)stream, 1, null);
                            }
                            resourcesFile.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                    processingProgressMonitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
            IProject[] iProjectArray = new IProject[]{project};
            return iProjectArray;
        }
        finally {
            monitor.done();
        }
    }

    private static IFile getResourceFile(IFolder inputFolder, IFile inputFile, IFolder outputFolder) {
        IPath relativePath = inputFile.getParent().getFullPath().makeRelativeTo(inputFolder.getFullPath());
        IFolder parentFolder = outputFolder.getFolder(relativePath);
        return parentFolder.getFile(String.valueOf(StringResourcesExtractorBuilder.getNameWithoutExtension(inputFile)) + ".properties");
    }

    private static String getNameWithoutExtension(IFile f) {
        String fname = f.getName();
        int lastdot = fname.lastIndexOf(46);
        if (lastdot == -1) {
            return fname;
        }
        return fname.substring(0, lastdot);
    }

    private static void create(IContainer container) throws CoreException {
        if (container.getType() == 2) {
            StringResourcesExtractorBuilder.create(container.getParent());
            if (!container.exists()) {
                IFolder folder = (IFolder)container;
                folder.create(true, true, null);
                folder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

