/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.ui.def.IActionGroupDef;
import org.eclipse.sapphire.ui.def.IActionOverride;
import org.eclipse.sapphire.ui.def.IActionSetDef;
import org.eclipse.sapphire.ui.def.internal.ActionGroupDef;
import org.eclipse.sapphire.ui.def.internal.ActionOverride;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionSetDef
extends ModelElementForXml
implements IActionSetDef {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_SUPPRESS_DEFAULT_ACTIONS = new XmlPath("suppress-default-actions", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private ModelElementList<IActionGroupDef> groups = null;
    private ModelElementList<IActionOverride> overrides = null;
    private Value<Boolean> suppressDefaultActions = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_SUPPRESS_DEFAULT_ACTIONS, PATH_SUPPRESS_DEFAULT_ACTIONS);
    }

    public ActionSetDef(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IActionGroupDef> getGroups() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.groups == null) {
                this.refresh((ModelProperty)PROP_GROUPS, true);
            }
            return this.groups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IActionOverride> getOverrides() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.overrides == null) {
                this.refresh((ModelProperty)PROP_OVERRIDES, true);
            }
            return this.overrides;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Boolean> getSuppressDefaultActions() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.suppressDefaultActions == null) {
                this.refresh((ModelProperty)PROP_SUPPRESS_DEFAULT_ACTIONS, true);
            }
            return this.suppressDefaultActions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSuppressDefaultActions(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SUPPRESS_DEFAULT_ACTIONS.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_SUPPRESS_DEFAULT_ACTIONS, true);
            if (!ActionSetDef.equal((String)this.suppressDefaultActions.getText(false), (String)value)) {
                this.validateEdit();
                boolean elementShouldBePresent = Boolean.TRUE.toString().equals(value);
                if (elementShouldBePresent) {
                    this.getXmlElement(true).getChildNode(PATH_SUPPRESS_DEFAULT_ACTIONS, true);
                } else {
                    XmlElement element = this.getXmlElement(false);
                    if (element != null) {
                        element.removeChildNode(PATH_SUPPRESS_DEFAULT_ACTIONS);
                    }
                }
                this.refresh((ModelProperty)PROP_SUPPRESS_DEFAULT_ACTIONS, false);
            }
        }
    }

    @Override
    public void setSuppressDefaultActions(Boolean value) {
        this.setSuppressDefaultActions(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_SUPPRESS_DEFAULT_ACTIONS, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_GROUPS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_GROUPS);
                if (this.groups == null && force) {
                    this.groups = new ModelElementList((IModelElement)this, PROP_GROUPS);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IActionGroupDef.TYPE, "action-group");
                    ModelElementListControllerForXml<IActionGroupDef> controller = new ModelElementListControllerForXml<IActionGroupDef>(typeToElementName.values()){

                        protected IActionGroupDef wrap(XmlElement element) {
                            return new ActionGroupDef((IModelParticle)this.getList(), (ModelProperty)PROP_GROUPS, element);
                        }

                        public IActionGroupDef createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return ActionSetDef.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_GROUPS, this.groups, new String[0]);
                    this.groups.init((ModelElementListController)controller);
                }
                if (this.groups != null && !(notified = this.groups.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_GROUPS);
                }
            } else if (property == PROP_OVERRIDES) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_OVERRIDES);
                if (this.overrides == null && force) {
                    this.overrides = new ModelElementList((IModelElement)this, PROP_OVERRIDES);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IActionOverride.TYPE, "override");
                    ModelElementListControllerForXml<IActionOverride> controller = new ModelElementListControllerForXml<IActionOverride>(typeToElementName.values()){

                        protected IActionOverride wrap(XmlElement element) {
                            return new ActionOverride((IModelParticle)this.getList(), (ModelProperty)PROP_OVERRIDES, element);
                        }

                        public IActionOverride createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return ActionSetDef.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_OVERRIDES, this.overrides, new String[0]);
                    this.overrides.init((ModelElementListController)controller);
                }
                if (this.overrides != null && !(notified = this.overrides.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_OVERRIDES);
                }
            } else if (property == PROP_SUPPRESS_DEFAULT_ACTIONS && (this.suppressDefaultActions != null || force)) {
                Value<Boolean> oldValue = this.suppressDefaultActions;
                XmlElement element = this.getXmlElement(false);
                XmlNode child = element == null ? null : element.getChildNode(PATH_SUPPRESS_DEFAULT_ACTIONS, false);
                String val = child != null ? Boolean.TRUE.toString() : null;
                this.suppressDefaultActions = new Value((IModelElement)this, PROP_SUPPRESS_DEFAULT_ACTIONS, PROP_SUPPRESS_DEFAULT_ACTIONS.encodeKeywords(val));
                this.suppressDefaultActions.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_SUPPRESS_DEFAULT_ACTIONS);
                if (oldValue != null) {
                    if (this.suppressDefaultActions.equals(oldValue)) {
                        this.suppressDefaultActions = oldValue;
                    }
                    if (this.suppressDefaultActions != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_SUPPRESS_DEFAULT_ACTIONS);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

