/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.ui.def.IDefinitionReference;
import org.eclipse.sapphire.ui.def.IImportDirective;
import org.eclipse.sapphire.ui.def.IPackageReference;
import org.eclipse.sapphire.ui.def.internal.DefinitionReference;
import org.eclipse.sapphire.ui.def.internal.ImportDirectiveMethods;
import org.eclipse.sapphire.ui.def.internal.PackageReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportDirective
extends ModelElementForXml
implements IImportDirective {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_BUNDLE = new XmlPath("bundle", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<String> bundle = null;
    private ModelElementList<IDefinitionReference> definitions = null;
    private ModelElementList<IPackageReference> packages = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_BUNDLE, PATH_BUNDLE);
    }

    public ImportDirective(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getBundle() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.bundle == null) {
                this.refresh((ModelProperty)PROP_BUNDLE, true);
            }
            return this.bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_BUNDLE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_BUNDLE, true);
            if (!ImportDirective.equal((String)this.bundle.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_BUNDLE, value, true);
                this.refresh((ModelProperty)PROP_BUNDLE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IDefinitionReference> getDefinitions() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.definitions == null) {
                this.refresh((ModelProperty)PROP_DEFINITIONS, true);
            }
            return this.definitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IPackageReference> getPackages() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.packages == null) {
                this.refresh((ModelProperty)PROP_PACKAGES, true);
            }
            return this.packages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class resolveClass(String className) {
        IModel iModel = this.model;
        synchronized (iModel) {
            return ImportDirectiveMethods.resolveClass(this, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDescriptor resolveImage(String imagePath) {
        IModel iModel = this.model;
        synchronized (iModel) {
            return ImportDirectiveMethods.resolveImage(this, imagePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_BUNDLE) {
                if (this.bundle != null || force) {
                    Value<String> oldValue = this.bundle;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_BUNDLE, false);
                    this.bundle = new Value((IModelElement)this, PROP_BUNDLE, PROP_BUNDLE.encodeKeywords(val));
                    this.bundle.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_BUNDLE);
                    if (oldValue != null) {
                        if (this.bundle.equals(oldValue)) {
                            this.bundle = oldValue;
                        }
                        if (this.bundle != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_BUNDLE);
                        }
                    }
                }
            } else if (property == PROP_DEFINITIONS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_DEFINITIONS);
                if (this.definitions == null && force) {
                    this.definitions = new ModelElementList((IModelElement)this, PROP_DEFINITIONS);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IDefinitionReference.TYPE, "definition");
                    ModelElementListControllerForXml<IDefinitionReference> controller = new ModelElementListControllerForXml<IDefinitionReference>(typeToElementName.values()){

                        protected IDefinitionReference wrap(XmlElement element) {
                            return new DefinitionReference((IModelParticle)this.getList(), (ModelProperty)PROP_DEFINITIONS, element);
                        }

                        public IDefinitionReference createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return ImportDirective.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_DEFINITIONS, this.definitions, new String[0]);
                    this.definitions.init((ModelElementListController)controller);
                }
                if (this.definitions != null && !(notified = this.definitions.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_DEFINITIONS);
                }
            } else if (property == PROP_PACKAGES) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PACKAGES);
                if (this.packages == null && force) {
                    this.packages = new ModelElementList((IModelElement)this, PROP_PACKAGES);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IPackageReference.TYPE, "package");
                    ModelElementListControllerForXml<IPackageReference> controller = new ModelElementListControllerForXml<IPackageReference>(typeToElementName.values()){

                        protected IPackageReference wrap(XmlElement element) {
                            return new PackageReference((IModelParticle)this.getList(), (ModelProperty)PROP_PACKAGES, element);
                        }

                        public IPackageReference createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return ImportDirective.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_PACKAGES, this.packages, new String[0]);
                    this.packages.init((ModelElementListController)controller);
                }
                if (this.packages != null && !(notified = this.packages.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_PACKAGES);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

