/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.SapphireMultiStatus;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ProblemOverlayImageDescriptor;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphireConditionManager;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartContext;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphirePropertyEnabledCondition;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireSection;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeDef;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeFactoryDef;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeFactoryEntry;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeFactoryRef;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeListEntry;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeRef;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphireSectionDef;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeAddAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeDeleteAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeMoveDownAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeMoveUpAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeShowInSourceAction;
import org.eclipse.sapphire.ui.editor.views.masterdetails.internal.ListPropertyNodeFactory;
import org.eclipse.sapphire.ui.internal.ActionsHostUtil;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsContentNode
extends SapphirePart {
    public static final String HINT_HIDE_IF_DISABLED = "hide.if.disabled";
    private static final ImageDescriptor IMG_DESC_CONTAINER = SapphireImageCache.OBJECT_CONTAINER_NODE;
    private static final ImageDescriptor IMG_DESC_CONTAINER_WITH_ERROR = new ProblemOverlayImageDescriptor(IMG_DESC_CONTAINER, 4);
    private static final ImageDescriptor IMG_DESC_CONTAINER_WITH_WARNING = new ProblemOverlayImageDescriptor(IMG_DESC_CONTAINER, 2);
    private static final ImageDescriptor IMG_DESC_LEAF = SapphireImageCache.OBJECT_LEAF_NODE;
    private static final ImageDescriptor IMG_DESC_LEAF_WITH_ERROR = new ProblemOverlayImageDescriptor(IMG_DESC_LEAF, 4);
    private static final ImageDescriptor IMG_DESC_LEAF_WITH_WARNING = new ProblemOverlayImageDescriptor(IMG_DESC_LEAF, 2);
    private MasterDetailsContentTree contentTree;
    private IMasterDetailsTreeNodeDef definition;
    private IModelElement modelElement;
    private ElementProperty modelElementProperty;
    private ModelElementListener modelElementListener;
    private MasterDetailsContentNode parentNode;
    private ValueProperty labelProperty;
    private Set<String> listProperties;
    private ImageDescriptor imageDescriptor;
    private ImageDescriptor imageDescriptorWithError;
    private ImageDescriptor imageDescriptorWithWarning;
    private SapphirePartListener childPartListener;
    private List<Object> rawChildren;
    private List<SapphireSection> sections;
    private List<SapphireSection> sectionsReadOnly;
    private List<ActionGroup> menuActions = null;
    private List<ActionGroup> toolbarActions = null;
    private boolean expanded;
    private SapphireConditionManager visibleWhenCondition;

    @Override
    protected void init() {
        String hideIfDisabled;
        super.init();
        ISapphirePart parent = this.getParentPart();
        this.parentNode = parent instanceof MasterDetailsContentNode ? (MasterDetailsContentNode)parent : null;
        this.contentTree = this.getNearestPart(MasterDetailsPage.class).getContentTree();
        this.definition = (IMasterDetailsTreeNodeDef)((SapphirePart)this).definition;
        this.modelElementProperty = (ElementProperty)this.resolve((String)this.definition.getProperty().getContent());
        if (this.modelElementProperty != null) {
            this.modelElement = (IModelElement)this.modelElementProperty.invokeGetterMethod((Object)this.getModelElement());
            this.modelElementListener = new ModelElementListener(){

                public void propertyChanged(ModelPropertyChangeEvent event) {
                    MasterDetailsContentNode.this.handleModelElementChange(event);
                }
            };
            this.modelElement.addListener(this.modelElementListener);
        } else {
            this.modelElement = this.getModelElement();
        }
        this.labelProperty = (ValueProperty)this.resolve((String)this.definition.getDynamicLabelProperty().getContent());
        this.imageDescriptor = (ImageDescriptor)this.definition.getImagePath().resolve();
        this.imageDescriptorWithError = null;
        this.imageDescriptorWithWarning = null;
        this.visibleWhenCondition = null;
        Class<SapphirePropertyEnabledCondition> visibleWhenConditionClass = null;
        String visibleWhenConditionParameter = null;
        IStatus visibleWhenConditionClassValidation = this.definition.getVisibleWhenConditionClass().validate();
        if (visibleWhenConditionClassValidation.getSeverity() != 4) {
            visibleWhenConditionClass = (Class<SapphirePropertyEnabledCondition>)this.definition.getVisibleWhenConditionClass().resolve();
            visibleWhenConditionParameter = this.definition.getVisibleWhenConditionParameter().getText();
        } else {
            SapphireUiFrameworkPlugin.log(visibleWhenConditionClassValidation);
        }
        if (visibleWhenConditionClass == null && this.modelElementProperty != null && Boolean.parseBoolean(hideIfDisabled = this.definition.getHint(HINT_HIDE_IF_DISABLED))) {
            visibleWhenConditionClass = SapphirePropertyEnabledCondition.class;
            visibleWhenConditionParameter = this.modelElementProperty.getName();
        }
        if (visibleWhenConditionClass != null) {
            Runnable onConditionChangeCallback = new Runnable(){

                public void run() {
                    MasterDetailsContentNode.this.getContentTree().refresh();
                }
            };
            this.visibleWhenCondition = SapphireConditionManager.create(this, visibleWhenConditionClass, visibleWhenConditionParameter, onConditionChangeCallback);
        }
        this.expanded = false;
        this.childPartListener = new SapphirePartListener(){

            public void handleValidateStateChange(IStatus oldValidateState, IStatus newValidationState) {
                MasterDetailsContentNode.this.updateValidationState();
            }
        };
        SapphirePartListener validationStateListener = new SapphirePartListener(){

            public void handleValidateStateChange(IStatus oldValidateState, IStatus newValidationState) {
                MasterDetailsContentNode.this.getContentTree().notifyOfNodeUpdate(MasterDetailsContentNode.this);
            }
        };
        this.addListener(validationStateListener);
        this.sections = new ArrayList<SapphireSection>();
        this.sectionsReadOnly = Collections.unmodifiableList(this.sections);
        for (ISapphireSectionDef secdef : this.definition.getSections()) {
            SapphireSection section = new SapphireSection();
            section.init(this, this.modelElement, secdef, Collections.<String, String>emptyMap());
            section.addListener(this.childPartListener);
            this.sections.add(section);
        }
        this.rawChildren = new ArrayList<Object>();
        for (Object entry : this.definition.getChildNodes()) {
            IMasterDetailsTreeNodeListEntry def;
            if (entry instanceof IMasterDetailsTreeNodeDef || entry instanceof IMasterDetailsTreeNodeRef) {
                def = entry instanceof IMasterDetailsTreeNodeDef ? (IMasterDetailsTreeNodeDef)entry : ((IMasterDetailsTreeNodeRef)entry).resolve();
                MasterDetailsContentNode node = new MasterDetailsContentNode();
                node.init(this, this.modelElement, (ISapphirePartDef)((Object)def), this.params);
                node.addListener(this.childPartListener);
                this.rawChildren.add(node);
                continue;
            }
            if (!(entry instanceof IMasterDetailsTreeNodeFactoryDef) && !(entry instanceof IMasterDetailsTreeNodeFactoryRef)) continue;
            def = entry instanceof IMasterDetailsTreeNodeFactoryDef ? (IMasterDetailsTreeNodeFactoryDef)entry : ((IMasterDetailsTreeNodeFactoryRef)entry).resolve();
            ListProperty listProperty = (ListProperty)this.resolve(this.getLocalModelElement(), (String)def.getListProperty().getContent());
            SapphireCondition factoryVisibleWhenCondition = null;
            Class factoryVisibleWhenConditionClass = (Class)def.getVisibleWhenConditionClass().resolve();
            if (factoryVisibleWhenConditionClass != null) {
                try {
                    factoryVisibleWhenCondition = (SapphireCondition)factoryVisibleWhenConditionClass.newInstance();
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
                if (factoryVisibleWhenCondition != null) {
                    String parameter = def.getVisibleWhenConditionParameter().getText();
                    factoryVisibleWhenCondition.init(new SapphirePartContext(this), parameter);
                }
            }
            ListPropertyNodeFactory factory = new ListPropertyNodeFactory(this.modelElement, listProperty, factoryVisibleWhenCondition, (IMasterDetailsTreeNodeFactoryDef)def){
                private final /* synthetic */ IMasterDetailsTreeNodeFactoryDef val$def;
                {
                    this.val$def = iMasterDetailsTreeNodeFactoryDef;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                protected MasterDetailsContentNode createNode(IModelElement listEntryModelElement) {
                    IMasterDetailsTreeNodeFactoryEntry listEntryNodeDef = null;
                    for (IMasterDetailsTreeNodeFactoryEntry entry : this.val$def.getTypeSpecificDefinitions()) {
                        Class type = (Class)entry.getType().resolve();
                        if (type != null && !type.isAssignableFrom(listEntryModelElement.getClass())) continue;
                        listEntryNodeDef = entry;
                        break;
                    }
                    if (listEntryNodeDef == null) {
                        throw new RuntimeException();
                    }
                    MasterDetailsContentNode node = new MasterDetailsContentNode();
                    node.init(MasterDetailsContentNode.this, listEntryModelElement, listEntryNodeDef, MasterDetailsContentNode.this.params);
                    node.addListener(MasterDetailsContentNode.this.childPartListener);
                    return node;
                }
            };
            this.rawChildren.add(factory);
        }
        this.listProperties = new HashSet<String>();
        for (Object entry : this.rawChildren) {
            if (!(entry instanceof ListPropertyNodeFactory)) continue;
            this.listProperties.add(((ListPropertyNodeFactory)entry).getListProperty().getName());
        }
    }

    public MasterDetailsContentTree getContentTree() {
        return this.contentTree;
    }

    public MasterDetailsContentNode getParentNode() {
        return this.parentNode;
    }

    public boolean isAncestorOf(MasterDetailsContentNode node) {
        MasterDetailsContentNode n = node;
        while (n != null) {
            if (n == this) {
                return true;
            }
            n = n.getParentNode();
        }
        return false;
    }

    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public String getLabel() {
        if (this.labelProperty != null) {
            Value value;
            Method labelPropertyGetter = this.labelProperty.getGetterMethod();
            try {
                value = (Value)labelPropertyGetter.invoke((Object)this.modelElement, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String label = value.getText(false);
            if (label == null) {
                label = this.definition.getDynamicLabelNullValueText().getLocalizedText();
            }
            return label;
        }
        return this.definition.getLabel().getLocalizedText();
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor base;
        IStatus st = this.getValidationState();
        int severity = st.getSeverity();
        if (((Boolean)this.definition.getUseModelElementImage().getContent()).booleanValue()) {
            Image img = this.getImageCache().getImage(this.getLocalModelElement());
            base = ImageDescriptor.createFromImage((Image)img);
        } else {
            base = this.imageDescriptor;
        }
        if (base == null) {
            if (severity == 4) {
                if (this.hasChildNodes()) {
                    return IMG_DESC_CONTAINER_WITH_ERROR;
                }
                return IMG_DESC_LEAF_WITH_ERROR;
            }
            if (severity == 2) {
                if (this.hasChildNodes()) {
                    return IMG_DESC_CONTAINER_WITH_WARNING;
                }
                return IMG_DESC_LEAF_WITH_WARNING;
            }
            if (this.hasChildNodes()) {
                return IMG_DESC_CONTAINER;
            }
            return IMG_DESC_LEAF;
        }
        if (severity == 4) {
            if (this.imageDescriptorWithError == null) {
                this.imageDescriptorWithError = new ProblemOverlayImageDescriptor(base, 4);
            }
            return this.imageDescriptorWithError;
        }
        if (severity == 2) {
            if (this.imageDescriptorWithWarning == null) {
                this.imageDescriptorWithWarning = new ProblemOverlayImageDescriptor(base, 2);
            }
            return this.imageDescriptorWithWarning;
        }
        return base;
    }

    public boolean isVisible() {
        if (this.visibleWhenCondition != null) {
            return this.visibleWhenCondition.getConditionState();
        }
        return true;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, false);
    }

    public void setExpanded(boolean expanded, boolean applyToChildren) {
        if (this.parentNode != null && !this.parentNode.isExpanded() && expanded) {
            this.parentNode.setExpanded(true);
        }
        if (this.expanded != expanded) {
            MasterDetailsContentNode selection;
            if (!expanded && (selection = this.getContentTree().getSelectedNode()) != null && this.isAncestorOf(selection)) {
                this.select();
            }
            if (expanded) {
                this.expanded = expanded;
                this.getContentTree().notifyOfNodeExpandedStateChange(this);
            }
        }
        if (applyToChildren) {
            for (MasterDetailsContentNode child : this.getChildNodes()) {
                if (!child.hasChildNodes()) continue;
                child.setExpanded(expanded, applyToChildren);
            }
        }
        if (this.expanded != expanded && !expanded) {
            this.expanded = expanded;
            this.getContentTree().notifyOfNodeExpandedStateChange(this);
        }
    }

    public List<MasterDetailsContentNode> getExpandedNodes() {
        ArrayList<MasterDetailsContentNode> result = new ArrayList<MasterDetailsContentNode>();
        this.getExpandedNodes(result);
        return result;
    }

    public void getExpandedNodes(List<MasterDetailsContentNode> result) {
        if (this.isExpanded()) {
            result.add(this);
            for (MasterDetailsContentNode child : this.getChildNodes()) {
                child.getExpandedNodes(result);
            }
        }
    }

    public void select() {
        this.getContentTree().setSelectedNode(this);
    }

    public List<ActionGroup> getMenuActions() {
        if (this.menuActions == null) {
            this.menuActions = new ArrayList<ActionGroup>();
            boolean isSameModelElementAsParent = this.parentNode != null ? this.modelElement == this.parentNode.getLocalModelElement() : false;
            ActionGroup addDeleteActionGroup = new ActionGroup();
            if (!this.getChildListProperties().isEmpty()) {
                addDeleteActionGroup.addAction(new NodeAddAction());
            }
            if (!isSameModelElementAsParent && this.modelElement instanceof IRemovable) {
                addDeleteActionGroup.addAction(new NodeDeleteAction());
            }
            if (addDeleteActionGroup.getActions().size() > 0) {
                this.menuActions.add(addDeleteActionGroup);
            }
            if (!isSameModelElementAsParent) {
                IModelParticle parent = this.modelElement.getParent();
                if (parent instanceof ModelElementList) {
                    ActionGroup moveActionGroup = new ActionGroup();
                    this.menuActions.add(moveActionGroup);
                    moveActionGroup.addAction(new NodeMoveUpAction());
                    moveActionGroup.addAction(new NodeMoveDownAction());
                }
                ActionGroup goToSourceActionGroup = new ActionGroup();
                goToSourceActionGroup.addAction(new NodeShowInSourceAction());
                this.menuActions.add(goToSourceActionGroup);
            }
            ActionsHostUtil.initActions(this.menuActions, this.definition.getActionSetDef());
            for (ActionGroup group : this.menuActions) {
                for (Action action : group.getActions()) {
                    action.setPart(this);
                }
            }
        }
        return this.menuActions;
    }

    public List<ActionGroup> getToolbarActions() {
        if (this.toolbarActions == null) {
            this.toolbarActions = new ArrayList<ActionGroup>();
            for (ActionGroup group : this.toolbarActions) {
                for (Action action : group.getActions()) {
                    action.setPart(this);
                }
            }
        }
        return this.toolbarActions;
    }

    @Override
    public Action getAction(String id) {
        Action action;
        for (ActionGroup group : this.getMenuActions()) {
            action = group.getAction(id);
            if (action == null) continue;
            return action;
        }
        for (ActionGroup group : this.getToolbarActions()) {
            action = group.getAction(id);
            if (action == null) continue;
            return action;
        }
        ISapphirePart parent = this.getParentPart();
        if (parent != null) {
            return parent.getAction(id);
        }
        return null;
    }

    public List<SapphireSection> getSections() {
        return this.sectionsReadOnly;
    }

    public List<ListProperty> getChildListProperties() {
        ArrayList<ListProperty> listProperties = new ArrayList<ListProperty>();
        for (Object object : this.rawChildren) {
            ListPropertyNodeFactory factory;
            if (!(object instanceof ListPropertyNodeFactory) || !(factory = (ListPropertyNodeFactory)object).isVisible()) continue;
            listProperties.add(factory.getListProperty());
        }
        return listProperties;
    }

    public boolean hasChildNodes() {
        return !this.rawChildren.isEmpty();
    }

    public List<MasterDetailsContentNode> getChildNodes() {
        ArrayList<MasterDetailsContentNode> nodes = new ArrayList<MasterDetailsContentNode>();
        for (Object entry : this.rawChildren) {
            if (entry instanceof MasterDetailsContentNode) {
                MasterDetailsContentNode node = (MasterDetailsContentNode)entry;
                if (!node.isVisible()) continue;
                nodes.add(node);
                continue;
            }
            if (entry instanceof ListPropertyNodeFactory) {
                ListPropertyNodeFactory factory = (ListPropertyNodeFactory)entry;
                if (!factory.isVisible()) continue;
                nodes.addAll(factory.createNodes());
                continue;
            }
            throw new IllegalStateException(entry.getClass().getName());
        }
        return nodes;
    }

    public MasterDetailsContentNode getChildNodeByLabel(String label) {
        for (MasterDetailsContentNode child : this.getChildNodes()) {
            if (!label.equals(child.getLabel())) continue;
            return child;
        }
        return null;
    }

    @Override
    protected IStatus computeValidationState() {
        SapphireMultiStatus st = new SapphireMultiStatus();
        for (SapphirePart sapphirePart : this.sections) {
            st.add(sapphirePart.getValidationState());
        }
        for (SapphirePart sapphirePart : this.getChildNodes()) {
            st.add(sapphirePart.getValidationState());
        }
        return st;
    }

    @Override
    protected void handleModelElementChange(ModelPropertyChangeEvent event) {
        super.handleModelElementChange(event);
        ModelProperty property = event.getProperty();
        if (this.labelProperty == property) {
            Runnable notifyOfUpdateOperation = new Runnable(){

                public void run() {
                    MasterDetailsContentNode.this.getContentTree().notifyOfNodeUpdate(MasterDetailsContentNode.this);
                }
            };
            Display.getDefault().asyncExec(notifyOfUpdateOperation);
        }
        if (this.listProperties != null && this.listProperties.contains(property.getName())) {
            Runnable notifyOfStructureChangeOperation = new Runnable(){

                public void run() {
                    MasterDetailsContentNode.this.getContentTree().notifyOfNodeStructureChange(MasterDetailsContentNode.this);
                    MasterDetailsContentNode.this.updateValidationState();
                }
            };
            Display.getDefault().asyncExec(notifyOfStructureChangeOperation);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.modelElementListener != null) {
            this.modelElement.removeListener(this.modelElementListener);
        }
        for (SapphirePart sapphirePart : this.sections) {
            sapphirePart.dispose();
        }
        for (SapphirePart sapphirePart : this.getChildNodes()) {
            sapphirePart.dispose();
        }
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }
}

