/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeMoveAction;
import org.eclipse.swt.widgets.Shell;

public class NodeMoveDownAction
extends NodeMoveAction {
    public static final String ACTION_ID = "node:move-down";

    public NodeMoveDownAction() {
        this.setId(ACTION_ID);
        this.setLabel(Resources.moveDownActionLabel);
        this.setImageDescriptor(SapphireImageCache.ACTION_MOVE_DOWN);
        this.setCommandId("sapphire.move.down");
    }

    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        IModelElement modelElement = this.getNode().getModelElement();
        ModelElementList list = (ModelElementList)modelElement.getParent();
        return list.indexOf((Object)modelElement) < list.size() - 1;
    }

    protected final Object run(Shell shell) {
        MasterDetailsContentNode node = this.getNode();
        IModelElement modelElement = node.getModelElement();
        ModelElementList list = (ModelElementList)modelElement.getParent();
        list.moveDown(modelElement);
        node.getContentTree().notifyOfNodeStructureChange(node.getParentNode());
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String moveDownActionLabel;

        static {
            Resources.initializeMessages((String)NodeMoveDownAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

