/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.ui.SapphireCommands;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButtonsGroup
extends Composite {
    private final SapphireRenderingContext context;
    private final List<Button> buttons;
    private final List<Button> buttonsReadOnly;
    private SelectionListener selectionListener;
    private Button selection;
    private List<SelectionListener> listeners;

    public RadioButtonsGroup(SapphireRenderingContext context, Composite composite, boolean vertical) {
        super(composite, 0);
        this.context = context;
        this.buttons = new ArrayList<Button>();
        this.buttonsReadOnly = Collections.unmodifiableList(this.buttons);
        this.selection = null;
        this.listeners = new CopyOnWriteArrayList<SelectionListener>();
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.pack = true;
        layout.type = vertical ? 512 : 256;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.spacing = 5;
        this.setLayout((Layout)layout);
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RadioButtonsGroup.this.handleWidgetSelectedEvent(event);
            }
        };
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        SwtUtil.setEnabledOnChildren(this, enabled);
    }

    public List<Button> getRadioButtons() {
        return this.buttonsReadOnly;
    }

    public Button addRadioButton(String text) {
        final Button button = new Button((Composite)this, 16);
        button.setText(text);
        this.context.adapt((Control)button);
        this.buttons.add(button);
        SapphireCommands.configurePropertyEditorContext((Control)button);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                RadioButtonsGroup.this.buttons.remove(button);
            }
        });
        button.addSelectionListener(this.selectionListener);
        return button;
    }

    public Button getSelection() {
        return this.selection;
    }

    public void setSelection(Button button) {
        this.selection = button;
        Control focusControl = button.getDisplay().getFocusControl();
        boolean groupHasFocus = false;
        for (Button b : this.buttons) {
            if (b != button) {
                b.setSelection(false);
            }
            if (b != focusControl) continue;
            groupHasFocus = true;
        }
        button.setSelection(true);
        if (groupHasFocus) {
            button.setFocus();
        }
    }

    public int getSelectionIndex() {
        Button selection = this.getSelection();
        return selection == null ? -1 : this.buttons.indexOf(selection);
    }

    public void setSelectionIndex(int selection) {
        this.setSelection(this.buttons.get(selection));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void handleWidgetSelectedEvent(SelectionEvent event) {
        Button b = (Button)event.getSource();
        if (b.getSelection()) {
            this.selection = b;
            for (SelectionListener listener : this.listeners) {
                try {
                    listener.widgetSelected(event);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        }
    }
}

