/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class BooleanPropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Button checkbox;

    public BooleanPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        SapphirePropertyEditor part = this.getPart();
        ValueProperty property = (ValueProperty)part.getProperty();
        String label = property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, true);
        if (property.hasAnnotation(Deprecated.class)) {
            label = String.valueOf(label) + " " + Resources.deprecatedLabelText;
        }
        this.setSpanBothColumns(true);
        Composite composite = this.createMainComposite(parent);
        composite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(composite);
        decorator.getControl().setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 0x1000000));
        this.checkbox = new Button(composite, 32);
        this.checkbox.setLayoutData((Object)SwtUtil.gd());
        this.checkbox.setText(label);
        this.context.adapt((Control)this.checkbox);
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean value = BooleanPropertyEditorRenderer.this.checkbox.getSelection();
                BooleanPropertyEditorRenderer.this.setPropertyValue(String.valueOf(value));
            }
        });
        decorator.addEditorControl((Control)composite);
        this.addControl((Control)this.checkbox);
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        Value value = this.getPropertyValue();
        if (value != null) {
            boolean newSimpleValue;
            boolean existingValue = this.checkbox.getSelection();
            if (value.getText(false) != null && value.getContent(false) == null) {
                newSimpleValue = false;
            } else {
                Boolean newValue = (Boolean)value.getContent(true);
                boolean bl = newSimpleValue = newValue != null ? newValue : false;
            }
            if (newSimpleValue != existingValue) {
                this.checkbox.setSelection(newSimpleValue);
            }
        } else {
            this.checkbox.setSelection(false);
        }
    }

    protected void handleFocusReceivedEvent() {
        this.checkbox.setFocus();
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            ModelProperty property = propertyEditorDefinition.getProperty();
            return property instanceof ValueProperty && property.isOfType(Boolean.class);
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new BooleanPropertyEditorRenderer(context, part);
        }
    }

    private static final class Resources
    extends NLS {
        public static String deprecatedLabelText;

        static {
            Resources.initializeMessages((String)BooleanPropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

