/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.LabelTransformer;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.BrowseHandler;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrowseCommandHandler
extends AbstractHandler {
    private final SapphireRenderingContext context;
    private final List<BrowseHandler> browseHandlers;

    public BrowseCommandHandler(SapphireRenderingContext context, List<BrowseHandler> browseHandlers) {
        this.context = context;
        this.browseHandlers = browseHandlers;
    }

    public Object execute(ExecutionEvent event) {
        if (this.browseHandlers.size() == 1) {
            this.invokeBrowseHandler(this.browseHandlers.get(0));
        } else {
            final Menu menu = new Menu((Decorations)this.context.getShell(), 8);
            final boolean[] menuItemSelected = new boolean[1];
            for (final BrowseHandler browseHandler : this.browseHandlers) {
                MenuItem menuItem = new MenuItem(menu, 8);
                String label = String.valueOf(LabelTransformer.transform((String)browseHandler.getLabel(), (CapitalizationType)CapitalizationType.FIRST_WORD_ONLY, (boolean)true)) + "...";
                menuItem.setText(label);
                Image image = this.context.getImageCache().getImage(browseHandler.getImageDescriptor());
                menuItem.setImage(image);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        menuItemSelected[0] = true;
                        BrowseCommandHandler.this.invokeBrowseHandler(browseHandler);
                        menu.dispose();
                    }
                });
            }
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent event) {
                    Runnable op = new Runnable(){

                        public void run() {
                            if (!menuItemSelected[0]) {
                                BrowseCommandHandler.this.handleBrowseCanceled();
                                menu.dispose();
                            }
                        }
                    };
                    menu.getDisplay().asyncExec(op);
                }
            });
            Rectangle rect = this.getInvokerBounds();
            Point pt = new Point(rect.x, rect.y + rect.height);
            menu.setLocation(pt);
            menu.setVisible(true);
        }
        return null;
    }

    protected abstract Rectangle getInvokerBounds();

    protected void handleBrowseCompleted(String text) {
    }

    protected void handleBrowseCanceled() {
    }

    private void invokeBrowseHandler(BrowseHandler browseHandler) {
        String text = browseHandler.browse(this.context);
        if (text != null) {
            this.handleBrowseCompleted(text);
        } else {
            this.handleBrowseCanceled();
        }
    }
}

