/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.ui.SapphireCommands;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.sapphire.ui.actions.ActionsCommandBridge;
import org.eclipse.sapphire.ui.actions.ActionsRenderer;
import org.eclipse.sapphire.ui.assist.BrowseHandler;
import org.eclipse.sapphire.ui.assist.JumpHandler;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.EnhancedComposite;
import org.eclipse.sapphire.ui.internal.ReadOnlyComboBoxCellEditor;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.renderers.swt.BrowseableTextCellEditor;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.util.HyperlinkTable;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListPropertyEditorRenderer
extends PropertyEditorRenderer {
    public static final String DATA_SELECTION_PROVIDER = "selection.provider";
    private PropertyEditorAssistDecorator decorator;
    private boolean exposeAddAction = true;
    private boolean exposeDeleteAction = true;
    private Table table;
    private TableViewer tableViewer;
    private SelectionProvider selectionProvider;
    private Runnable refreshOperation;
    private ModelElementListener listElementListener;

    public DefaultListPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    @Override
    protected void createContents(Composite parent) {
        this.createContents(parent, false, false);
    }

    protected Control createContents(Composite parent, boolean suppressLabel, boolean ignoreLeftMarginHint) {
        TableColumnLayout tableColumnLayout;
        EnhancedComposite tableParentComposite;
        boolean renderAsList;
        EnhancedComposite innerComposite;
        Label label;
        final SapphirePropertyEditor part = this.getPart();
        IModelElement element = part.getModelElement();
        ListProperty property = (ListProperty)part.getProperty();
        boolean isReadOnly = property.isReadOnly() || part.getRenderingHint("read.only", false);
        boolean showLabelAbove = part.getRenderingHint("show.label.above", false);
        boolean showLabelInline = part.getRenderingHint("show.label", suppressLabel ? false : !showLabelAbove);
        int leftMargin = ignoreLeftMarginHint ? 0 : part.getLeftMarginHint();
        boolean showHeader = part.getRenderingHint("show.header", true);
        if (showLabelInline || showLabelAbove) {
            String labelText = String.valueOf(property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true)) + ":";
            label = new Label(parent, 0);
            label.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.hspan(SwtUtil.valign(SwtUtil.gd(), 128), showLabelAbove ? 2 : 1), leftMargin + 9));
            label.setText(labelText);
            this.context.adapt((Control)label);
        } else {
            label = null;
        }
        boolean expandVertically = part.getRenderingHint("expand.vertically", false);
        int heightHint = part.getRenderingHint("height", 10) * 15;
        GridData gd = expandVertically ? SwtUtil.gdfill() : SwtUtil.gdhhint(SwtUtil.gdhfill(), heightHint);
        gd = SwtUtil.gdhindent(SwtUtil.hspan(gd, showLabelInline ? 1 : 2), showLabelInline ? 0 : leftMargin);
        EnhancedComposite tableComposite = new EnhancedComposite(parent, 0);
        tableComposite.setLayoutData(gd);
        tableComposite.setLayout((Layout)SwtUtil.glayout(isReadOnly ? 1 : 2, 0, 0, 0, 0));
        this.context.adapt((Control)tableComposite);
        if (this.decorator == null) {
            innerComposite = new Composite((Composite)tableComposite, 0);
            innerComposite.setLayoutData(SwtUtil.gdfill());
            innerComposite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 2));
            this.context.adapt((Control)innerComposite);
            this.decorator = new PropertyEditorAssistDecorator(part, this.context, innerComposite);
            this.decorator.getControl().setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 128));
            this.decorator.addEditorControl((Control)innerComposite);
        } else {
            innerComposite = tableComposite;
        }
        this.decorator.addEditorControl((Control)tableComposite);
        final ArrayList<SapphirePropertyEditor.ChildPropertyHelper> columnProperties = new ArrayList<SapphirePropertyEditor.ChildPropertyHelper>();
        for (SapphirePropertyEditor.ChildPropertyHelper childProperty : part.getChildProperties()) {
            if (!(childProperty.getProperty() instanceof ValueProperty)) continue;
            columnProperties.add(childProperty);
        }
        boolean singleColumnTable = columnProperties.size() == 1;
        boolean bl = renderAsList = singleColumnTable && !showHeader && !((SapphirePropertyEditor.ChildPropertyHelper)columnProperties.get(0)).getProperty().isOfType(Boolean.class);
        if (renderAsList) {
            tableParentComposite = innerComposite;
            tableColumnLayout = null;
        } else {
            tableParentComposite = new Composite((Composite)innerComposite, 0);
            tableParentComposite.setLayoutData(SwtUtil.gdwhint(SwtUtil.gdfill(), 1));
            tableColumnLayout = new TableColumnLayout();
            tableParentComposite.setLayout((Layout)tableColumnLayout);
        }
        this.tableViewer = new TableViewer((Composite)tableParentComposite, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData(renderAsList ? SwtUtil.gdwhint(SwtUtil.gdfill(), 200) : null);
        this.table.setData("assist-decorator", (Object)this.decorator);
        this.context.adapt((Control)this.table);
        this.decorator.addEditorControl((Control)this.table);
        ArrayList<Label> relatedControls = new ArrayList<Label>();
        this.table.setData("related-controls", relatedControls);
        if (label != null) {
            relatedControls.add(label);
        }
        SapphireCommands.configurePropertyEditorContext((Control)this.table);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = Math.max(event.height, 18);
            }
        });
        final ArrayList<ColumnHandler> columnHandlers = new ArrayList<ColumnHandler>();
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                int columnIndex = ((ViewerCell)event.getSource()).getColumnIndex();
                ColumnHandler columnHandler = (ColumnHandler)columnHandlers.get(columnIndex);
                return columnHandler.isEditorActivationEvent(event);
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, null, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)1);
        this.table.setHeaderVisible(showHeader);
        this.selectionProvider = new SelectionProvider(this.tableViewer);
        this.table.setData(DATA_SELECTION_PROVIDER, (Object)this.selectionProvider);
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                DefaultListPropertyEditorRenderer.this.handleTableFocusGainedEvent();
            }
        });
        this.refreshOperation = new Runnable(){
            boolean running = false;

            public void run() {
                if (DefaultListPropertyEditorRenderer.this.table.isDisposed()) {
                    return;
                }
                if (this.running) {
                    return;
                }
                this.running = true;
                try {
                    DefaultListPropertyEditorRenderer.this.tableViewer.refresh();
                    DefaultListPropertyEditorRenderer.this.table.notifyListeners(13, null);
                }
                finally {
                    this.running = false;
                }
            }
        };
        this.binding = new AbstractBinding(element, (ModelProperty)property, this.context, (Control)this.table){

            protected void doUpdateModel() {
            }

            protected void doUpdateTarget() {
                DefaultListPropertyEditorRenderer.this.refreshOperation.run();
            }
        };
        this.table.setData("binding", (Object)this.binding);
        final ArrayList<ActionGroup> actions = new ArrayList<ActionGroup>();
        if (renderAsList) {
            SapphirePropertyEditor.ChildPropertyHelper memberPropertyHelper = (SapphirePropertyEditor.ChildPropertyHelper)columnProperties.get(0);
            ValueProperty memberProperty = (ValueProperty)memberPropertyHelper.getProperty();
            ColumnHandler columnHandler = this.createColumnHandler(columnHandlers, memberPropertyHelper, true);
            TableLabelProvider labelProvider = new TableLabelProvider((ColumnLabelProvider)columnHandler.getLabelProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            if (!memberProperty.isReadOnly()) {
                Object editingSupport = columnHandler.getEditingSupport();
                this.tableViewer.setColumnProperties(new String[]{"a"});
                ICellModifier cellModifier = new ICellModifier((AbstractColumnEditingSupport)((Object)editingSupport)){
                    private final /* synthetic */ AbstractColumnEditingSupport val$editingSupport;
                    {
                        this.val$editingSupport = abstractColumnEditingSupport;
                    }

                    public boolean canModify(Object element, String property) {
                        return this.val$editingSupport.canEdit(element);
                    }

                    public Object getValue(Object element, String property) {
                        return this.val$editingSupport.getValue(element);
                    }

                    public void modify(Object element, String property, Object value) {
                        TableItem tableItem = (TableItem)element;
                        this.val$editingSupport.setValue(tableItem.getData(), value);
                    }
                };
                this.tableViewer.setCellModifier(cellModifier);
                this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener((AbstractColumnEditingSupport)((Object)editingSupport)){
                    private final /* synthetic */ AbstractColumnEditingSupport val$editingSupport;
                    {
                        this.val$editingSupport = abstractColumnEditingSupport;
                    }

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection ssel = (IStructuredSelection)DefaultListPropertyEditorRenderer.this.tableViewer.getSelection();
                        Object sel = ssel.getFirstElement();
                        if (sel != null) {
                            CellEditor cellEditor = this.val$editingSupport.getCellEditor(sel);
                            DefaultListPropertyEditorRenderer.this.tableViewer.setCellEditors(new CellEditor[]{cellEditor});
                        }
                    }
                });
            }
        } else {
            boolean showImages = true;
            for (ModelElementType modelElementType : property.getAllPossibleTypes()) {
                if (modelElementType.getAnnotation(Image.class) != null) continue;
                showImages = false;
                break;
            }
            String columnWidthsHint = part.getRenderingHint("column.widths", "");
            StringTokenizer columnWidthsHintTokenizer = new StringTokenizer(columnWidthsHint, ",");
            for (SapphirePropertyEditor.ChildPropertyHelper memberPropertyHelper : columnProperties) {
                String columnWidthHint;
                String[] columnWidthHintSplit;
                ValueProperty memberProperty = (ValueProperty)memberPropertyHelper.getProperty();
                TableViewerColumn col2 = new TableViewerColumn(this.tableViewer, 0);
                col2.getColumn().setText(memberProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false));
                ColumnWeightData columnWeightData = null;
                if (columnWidthsHintTokenizer.hasMoreTokens() && ((columnWidthHintSplit = (columnWidthHint = columnWidthsHintTokenizer.nextToken()).split(":")).length == 1 || columnWidthHintSplit.length == 2)) {
                    try {
                        int minColumnWidth = Integer.parseInt(columnWidthHintSplit[0].trim());
                        int columnWeight = columnWidthHintSplit.length == 2 ? Integer.parseInt(columnWidthHintSplit[1].trim()) : 0;
                        columnWeightData = new ColumnWeightData(columnWeight, minColumnWidth, true);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (columnWeightData == null) {
                    columnWeightData = new ColumnWeightData(1, 100, true);
                }
                tableColumnLayout.setColumnData((Widget)col2.getColumn(), columnWeightData);
                final ColumnHandler columnHandler = this.createColumnHandler(columnHandlers, memberPropertyHelper, showImages);
                showImages = false;
                col2.setLabelProvider(columnHandler.getLabelProvider());
                col2.setEditingSupport((EditingSupport)columnHandler.getEditingSupport());
                final TableColumn tableColumn = col2.getColumn();
                tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        TableColumn currentSortColumn = DefaultListPropertyEditorRenderer.this.table.getSortColumn();
                        if (currentSortColumn != tableColumn) {
                            DefaultListPropertyEditorRenderer.this.table.setSortColumn(tableColumn);
                            DefaultListPropertyEditorRenderer.this.table.setSortDirection(1024);
                            DefaultListPropertyEditorRenderer.this.tableViewer.setComparator((ViewerComparator)new TableSorter(columnHandler, 1024));
                        } else {
                            int currentSortDirection = DefaultListPropertyEditorRenderer.this.table.getSortDirection();
                            if (currentSortDirection == 1024) {
                                DefaultListPropertyEditorRenderer.this.table.setSortDirection(128);
                                DefaultListPropertyEditorRenderer.this.tableViewer.setComparator((ViewerComparator)new TableSorter(columnHandler, 128));
                            } else {
                                DefaultListPropertyEditorRenderer.this.table.setSortColumn(null);
                                DefaultListPropertyEditorRenderer.this.tableViewer.setComparator(null);
                            }
                        }
                        for (ActionGroup group : actions) {
                            for (Action action : group.getActions()) {
                                action.notifyChangeListeners();
                            }
                        }
                    }
                });
            }
        }
        this.listElementListener = new ModelElementListener(){

            public void propertyChanged(ModelPropertyChangeEvent event) {
                DefaultListPropertyEditorRenderer.this.handleListElementChangedEvent(event);
            }
        };
        this.attachListElementListener();
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
                if (list != null) {
                    return list.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setInput((Object)contentProvider);
        if (!isReadOnly) {
            AddAction addAction = null;
            DeleteAction deleteAction = null;
            if (this.exposeAddAction) {
                Action.Listener addActionListener = new Action.Listener(){

                    public void handleActionExecuted(Action action, Object result) {
                        if (DefaultListPropertyEditorRenderer.this.table.isDisposed()) {
                            return;
                        }
                        IModelElement newListElement = (IModelElement)result;
                        if (newListElement != null) {
                            DefaultListPropertyEditorRenderer.this.refreshOperation.run();
                            DefaultListPropertyEditorRenderer.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newListElement), true);
                            DefaultListPropertyEditorRenderer.this.tableViewer.editElement((Object)newListElement, 0);
                            DefaultListPropertyEditorRenderer.this.table.notifyListeners(13, null);
                        }
                    }
                };
                addAction = new AddAction(addActionListener);
                addAction.setPart(part);
            }
            if (this.exposeDeleteAction) {
                deleteAction = new DeleteAction();
                deleteAction.setPart(part);
            }
            if (addAction != null || deleteAction != null) {
                ActionGroup addDeleteActionGroup = new ActionGroup();
                actions.add(addDeleteActionGroup);
                if (addAction != null) {
                    addDeleteActionGroup.addAction(addAction);
                }
                if (deleteAction != null) {
                    addDeleteActionGroup.addAction(deleteAction);
                }
            }
            if (!property.hasAnnotation(FixedOrderList.class)) {
                ActionGroup moveActionGroup = new ActionGroup();
                actions.add(moveActionGroup);
                Action.Listener moveActionListener = new Action.Listener(){

                    public void handleActionExecuted(Action action, Object result) {
                        DefaultListPropertyEditorRenderer.this.refreshOperation.run();
                    }
                };
                MoveUpAction moveUpAction = new MoveUpAction(moveActionListener);
                moveUpAction.setPart(part);
                moveActionGroup.addAction(moveUpAction);
                MoveDownAction moveDownAction = new MoveDownAction(moveActionListener);
                moveDownAction.setPart(part);
                moveActionGroup.addAction(moveDownAction);
            }
            ToolBar toolbar = new ToolBar((Composite)tableComposite, 0x800200);
            toolbar.setLayoutData((Object)SwtUtil.gdvfill());
            this.context.adapt((Control)toolbar);
            this.decorator.addEditorControl((Control)toolbar);
            ActionsRenderer.fillToolBar(toolbar, actions);
            ActionsCommandBridge actionsCommandBridge = new ActionsCommandBridge((Control)this.table);
            actionsCommandBridge.setActions(actions);
            Menu menu = new Menu((Control)this.table);
            this.table.setMenu(menu);
            ActionsRenderer.fillMenu(menu, actions);
        }
        HyperlinkTable hyperlinkTable = new HyperlinkTable(this.table);
        hyperlinkTable.setController(new HyperlinkTable.Controller(){

            public boolean isHyperlinkEnabled(TableItem item, int column) {
                IModelElement element = (IModelElement)item.getData();
                SapphirePropertyEditor.ChildPropertyHelper propertyHelper = (SapphirePropertyEditor.ChildPropertyHelper)columnProperties.get(column);
                JumpHandler jumpHandler = propertyHelper.createJumpHandler(element);
                if (jumpHandler != null) {
                    return jumpHandler.canLocateJumpTarget(part, DefaultListPropertyEditorRenderer.this.context, element, (ValueProperty)propertyHelper.getProperty());
                }
                return false;
            }

            public void handleHyperlinkEvent(TableItem item, int column) {
                IModelElement element = (IModelElement)item.getData();
                SapphirePropertyEditor.ChildPropertyHelper propertyHelper = (SapphirePropertyEditor.ChildPropertyHelper)columnProperties.get(column);
                JumpHandler jumpHandler = propertyHelper.createJumpHandler(element);
                if (jumpHandler != null) {
                    jumpHandler.jump(part, DefaultListPropertyEditorRenderer.this.context, element, (ValueProperty)propertyHelper.getProperty());
                }
            }
        });
        this.addControl((Control)this.table);
        return this.table;
    }

    public final ListProperty getProperty() {
        return (ListProperty)super.getProperty();
    }

    public final ModelElementList<IModelElement> getList() {
        IModelElement modelElement = this.getModelElement();
        if (modelElement != null) {
            return (ModelElementList)this.getProperty().invokeGetterMethod((Object)modelElement);
        }
        return null;
    }

    public final PropertyEditorAssistDecorator getDecorator() {
        return this.decorator;
    }

    public final void setDecorator(PropertyEditorAssistDecorator decorator) {
        this.decorator = decorator;
    }

    public final boolean isAddActionDesired() {
        return this.exposeAddAction;
    }

    public final void setAddActionDesired(boolean exposeAddAction) {
        this.exposeAddAction = exposeAddAction;
    }

    public final boolean isDeleteActionDesired() {
        return this.exposeDeleteAction;
    }

    public final void setDeleteActionDesired(boolean exposeDeleteAction) {
        this.exposeDeleteAction = exposeDeleteAction;
    }

    public final void setSelection(List<IModelElement> selection) {
        StructuredSelection sel = new StructuredSelection(selection);
        this.tableViewer.setSelection((ISelection)sel);
    }

    public final void setFocusOnTable() {
        this.table.setFocus();
    }

    @Override
    protected void handlePropertyChangedEvent() {
        this.refreshOperation.run();
        this.attachListElementListener();
    }

    protected void handleListElementChangedEvent(final ModelPropertyChangeEvent event) {
        this.table.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DefaultListPropertyEditorRenderer.this.tableViewer.update((Object)event.getModelElement(), null);
                DefaultListPropertyEditorRenderer.this.binding.updateTargetAttributes();
            }
        });
    }

    protected void handleTableFocusGainedEvent() {
        if (this.tableViewer.getSelection().isEmpty() && this.table.getItemCount() > 0) {
            IModelElement firstItem = (IModelElement)this.table.getItem(0).getData();
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)firstItem));
        }
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.table.setFocus();
    }

    @Override
    protected void handleDisposeEvent() {
        ModelElementList<IModelElement> list = this.getList();
        if (list != null) {
            for (IModelElement entry : list) {
                entry.removeListener(this.listElementListener);
            }
        }
    }

    private void attachListElementListener() {
        ModelElementList<IModelElement> list = this.getList();
        if (list != null) {
            for (IModelElement entry : list) {
                entry.addListener(this.listElementListener);
            }
        }
    }

    private ColumnHandler createColumnHandler(List<ColumnHandler> allColumnHandlers, SapphirePropertyEditor.ChildPropertyHelper childPropertyHelper, boolean showImages) {
        ModelProperty property = childPropertyHelper.getProperty();
        ColumnHandler columnHandler = property.isOfType(Boolean.class) ? new BooleanPropertyColumnHandler(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, childPropertyHelper, showImages) : (property.isOfType(Enum.class) ? new EnumPropertyColumnHandler(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, childPropertyHelper, showImages) : new ColumnHandler(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, childPropertyHelper, showImages));
        allColumnHandlers.add(columnHandler);
        return columnHandler;
    }

    private abstract class AbstractAction
    extends Action {
        private final ModelPropertyListener listPropertyListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                AbstractAction.this.notifyChangeListeners();
            }
        };

        public AbstractAction() {
            DefaultListPropertyEditorRenderer.this.getModelElement().addListener(this.listPropertyListener, DefaultListPropertyEditorRenderer.this.getProperty().getName());
        }

        public boolean isEnabled() {
            IModelElement modelElement = DefaultListPropertyEditorRenderer.this.getModelElement();
            return modelElement != null && modelElement.isPropertyEnabled((ModelProperty)DefaultListPropertyEditorRenderer.this.getProperty());
        }

        public void dispose() {
            super.dispose();
            DefaultListPropertyEditorRenderer.this.getModelElement().removeListener(this.listPropertyListener, DefaultListPropertyEditorRenderer.this.getProperty().getName());
        }
    }

    private static abstract class AbstractColumnEditingSupport
    extends EditingSupport {
        protected final ColumnHandler columnHandler;

        public AbstractColumnEditingSupport(ColumnHandler columnHandler) {
            super((ColumnViewer)columnHandler.getTableViewer());
            this.columnHandler = columnHandler;
        }

        public boolean canEdit(Object element) {
            ValueProperty property = this.columnHandler.getProperty();
            return !property.isReadOnly() && ((IModelElement)element).isPropertyEnabled((ModelProperty)property);
        }

        public abstract CellEditor getCellEditor(Object var1);

        public abstract Object getValue(Object var1);

        public abstract void setValue(Object var1, Object var2);
    }

    private final class AddAction
    extends AbstractAction {
        public AddAction(Action.Listener actionListener) {
            this.setLabel(Resources.addActionLabel);
            this.setImageDescriptor(SapphireImageCache.ACTION_ADD);
            this.addListener(actionListener);
            if (DefaultListPropertyEditorRenderer.this.getProperty().getAllPossibleTypes().size() > 1) {
                ActionGroup mainAddActionGroup = new ActionGroup();
                this.addChildActionGroup(mainAddActionGroup);
                for (ModelElementType memberType : DefaultListPropertyEditorRenderer.this.getProperty().getAllPossibleTypes()) {
                    TypeSpecificAddAction typeSpecificAddAction = new TypeSpecificAddAction(memberType);
                    typeSpecificAddAction.addListener(actionListener);
                    mainAddActionGroup.addAction(typeSpecificAddAction);
                }
            }
        }

        protected Object run(Shell shell) {
            if (!this.getChildActionGroups().isEmpty()) {
                throw new UnsupportedOperationException();
            }
            return DefaultListPropertyEditorRenderer.this.getList().addNewElement();
        }

        private final class TypeSpecificAddAction
        extends Action {
            private final ModelElementType type;

            public TypeSpecificAddAction(ModelElementType type) {
                this.type = type;
                ImageDescriptor typeSpecificAddImage = DefaultListPropertyEditorRenderer.this.getPart().getImageCache().getImageDescriptor(this.type);
                if (typeSpecificAddImage == null) {
                    typeSpecificAddImage = this.getImageDescriptor();
                }
                this.setLabel(this.type.getLabel(false, CapitalizationType.TITLE_STYLE, false));
                this.setImageDescriptor(typeSpecificAddImage);
            }

            protected Object run(Shell shell) {
                return DefaultListPropertyEditorRenderer.this.getList().addNewElement(this.type);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BooleanPropertyColumnHandler
    extends ColumnHandler {
        private static final int CHECKBOX_IMAGE_WIDTH = 16;
        private static final int CHECKBOX_IMAGE_HEIGHT = 16;

        public BooleanPropertyColumnHandler(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, SapphirePropertyEditor listPropertyEditor, List<ColumnHandler> allColumnHandlers, SapphirePropertyEditor.ChildPropertyHelper childPropertyHelper, boolean showElementImage) {
            super(context, tableViewer, selectionProvider, listPropertyEditor, allColumnHandlers, childPropertyHelper, showElementImage);
        }

        @Override
        protected CellLabelProvider createLabelProvider() {
            return new OwnerDrawLabelProvider(){

                protected void erase(Event event, Object element) {
                }

                protected void measure(Event event, Object element) {
                }

                protected void paint(Event event, Object object) {
                    TableItem item = (TableItem)event.item;
                    IModelElement element = (IModelElement)item.getData();
                    if (element.isPropertyEnabled((ModelProperty)BooleanPropertyColumnHandler.this.getProperty())) {
                        boolean value = BooleanPropertyColumnHandler.this.getPropertyValueAsBoolean(element);
                        org.eclipse.swt.graphics.Image image = BooleanPropertyColumnHandler.this.getImageCache().getImage(value ? SapphireImageCache.OBJECT_CHECK_ON : SapphireImageCache.OBJECT_CHECK_OFF);
                        Rectangle cellBounds = item.getBounds(event.index);
                        Rectangle imageBounds = image.getBounds();
                        int x = event.x + (cellBounds.width - imageBounds.width) / 2;
                        int y = event.y + (cellBounds.height - imageBounds.height) / 2;
                        event.gc.drawImage(image, x, y);
                    }
                }
            };
        }

        @Override
        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private CheckboxCellEditor cellEditor;

                public CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        this.cellEditor = new CheckboxCellEditor((Composite)BooleanPropertyColumnHandler.this.getTable());
                    }
                    return this.cellEditor;
                }

                public Object getValue(Object element) {
                    Value<?> value = BooleanPropertyColumnHandler.this.getPropertyValue((IModelElement)element);
                    Boolean val = (Boolean)value.getContent();
                    return val != null ? val : Boolean.FALSE;
                }

                public void setValue(Object element, Object value) {
                    String str = String.valueOf((Boolean)value);
                    BooleanPropertyColumnHandler.this.setPropertyValue((IModelElement)element, str);
                }
            };
        }

        @Override
        public boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            if (event.eventType == 2) {
                Rectangle cellBounds = ((ViewerCell)event.getSource()).getBounds();
                Rectangle checkBoxBounds = new Rectangle(cellBounds.x + (cellBounds.width - 16) / 2, cellBounds.y + (cellBounds.height - 16) / 2, 16, 16);
                MouseEvent evt = (MouseEvent)event.sourceEvent;
                return checkBoxBounds.contains(evt.x, evt.y);
            }
            return false;
        }

        @Override
        public int comparePropertyValues(IModelElement x, IModelElement y) {
            boolean b;
            boolean a = this.getPropertyValueAsBoolean(x);
            if (a == (b = this.getPropertyValueAsBoolean(y))) {
                return 0;
            }
            if (a) {
                return -1;
            }
            return 1;
        }

        private boolean getPropertyValueAsBoolean(IModelElement element) {
            Value<?> value = this.getPropertyValue(element);
            Boolean val = (Boolean)value.getContent();
            return val != null && val != false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnHandler {
        protected final SapphireRenderingContext context;
        protected final Table table;
        protected final TableViewer tableViewer;
        protected final SelectionProvider selectionProvider;
        protected final SapphirePropertyEditor listPropertyEditor;
        protected final List<ColumnHandler> allColumnHandlers;
        protected final SapphirePropertyEditor.ChildPropertyHelper childPropertyHelper;
        protected final ValueProperty property;
        protected final boolean showElementImage;
        protected final Collator collator;
        private CellLabelProvider labelProvider;
        private AbstractColumnEditingSupport editingSupport;

        public ColumnHandler(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, SapphirePropertyEditor listPropertyEditor, List<ColumnHandler> allColumnHandlers, SapphirePropertyEditor.ChildPropertyHelper childPropertyHelper, boolean showElementImage) {
            this.context = context;
            this.table = tableViewer.getTable();
            this.tableViewer = tableViewer;
            this.selectionProvider = selectionProvider;
            this.listPropertyEditor = listPropertyEditor;
            this.allColumnHandlers = allColumnHandlers;
            this.childPropertyHelper = childPropertyHelper;
            this.property = (ValueProperty)childPropertyHelper.getProperty();
            this.showElementImage = showElementImage;
            this.collator = Collator.getInstance();
        }

        public final SapphireRenderingContext getContext() {
            return this.context;
        }

        public final Table getTable() {
            return this.table;
        }

        public final TableViewer getTableViewer() {
            return this.tableViewer;
        }

        public final SelectionProvider getSelectionProvider() {
            return this.selectionProvider;
        }

        public final SapphirePropertyEditor getListPropertyEditor() {
            return this.listPropertyEditor;
        }

        public final SapphireImageCache getImageCache() {
            return this.listPropertyEditor.getImageCache();
        }

        public final boolean isElementImageDesired() {
            return this.showElementImage;
        }

        public final ValueProperty getProperty() {
            return this.property;
        }

        public final Value<?> getPropertyValue(IModelElement element) {
            return (Value)this.property.invokeGetterMethod((Object)element);
        }

        public final void setPropertyValue(IModelElement element, String value) {
            this.property.invokeSetterMethod((Object)element, (Object)value);
        }

        public final CellLabelProvider getLabelProvider() {
            if (this.labelProvider == null) {
                this.labelProvider = this.createLabelProvider();
            }
            return this.labelProvider;
        }

        protected CellLabelProvider createLabelProvider() {
            return new DefaultColumnLabelProvider(this);
        }

        public final AbstractColumnEditingSupport getEditingSupport() {
            if (this.editingSupport == null && !this.property.isReadOnly()) {
                this.editingSupport = this.createEditingSupport();
            }
            return this.editingSupport;
        }

        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private BrowseableTextCellEditor cellEditor;

                public CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        int style = ColumnHandler.this.getTable().getLinesVisible() ? 0 : 2048;
                        this.cellEditor = new BrowseableTextCellEditor(ColumnHandler.this.getListPropertyEditor(), (StructuredViewer)ColumnHandler.this.getTableViewer(), ColumnHandler.this.getSelectionProvider(), style);
                        if (ColumnHandler.this.isElementImageDesired()) {
                            this.cellEditor.setHorizonalIndent(3);
                        }
                    }
                    List<BrowseHandler> browseHandlers = ColumnHandler.this.childPropertyHelper.createBrowseHandlers((IModelElement)element);
                    this.cellEditor.setBrowseHandlers(browseHandlers);
                    this.cellEditor.setContext(ColumnHandler.this.getContext());
                    return this.cellEditor;
                }

                public Object getValue(Object element) {
                    return ColumnHandler.this.getPropertyValue((IModelElement)element);
                }

                public void setValue(Object element, Object value) {
                    ColumnHandler.this.setPropertyValue((IModelElement)element, (String)value);
                }
            };
        }

        public boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            return event.eventType == 3 || event.eventType == 4;
        }

        public int comparePropertyValues(IModelElement x, IModelElement y) {
            boolean bEmpty;
            String a = this.getPropertyValue(x).getText();
            String b = this.getPropertyValue(y).getText();
            boolean aEmpty = a == null || a.trim().length() == 0;
            boolean bl = bEmpty = b == null || b.trim().length() == 0;
            if (aEmpty && bEmpty) {
                return 0;
            }
            if (aEmpty) {
                return 1;
            }
            if (bEmpty) {
                return -1;
            }
            return this.collator.compare(a, b);
        }

        public boolean isEmptyTextLabelDesired(IModelElement element) {
            if (this.allColumnHandlers.get(0) == this) {
                for (ColumnHandler handler : this.allColumnHandlers) {
                    if (!(handler instanceof BooleanPropertyColumnHandler)) continue;
                    return false;
                }
                for (ColumnHandler handler : this.allColumnHandlers) {
                    if (handler.getPropertyValue(element).getText() == null) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultColumnLabelProvider
    extends ColumnLabelProvider {
        private final ColumnHandler columnHandler;

        public DefaultColumnLabelProvider(ColumnHandler columnHandler) {
            this.columnHandler = columnHandler;
        }

        public String getText(Object element) {
            String str = null;
            IModelElement modelElement = (IModelElement)element;
            if (modelElement.isPropertyEnabled((ModelProperty)this.columnHandler.getProperty())) {
                str = this.getTextInternal(this.columnHandler.getPropertyValue(modelElement));
            }
            if (str == null) {
                str = this.columnHandler.isEmptyTextLabelDesired(modelElement) ? Resources.emptyRowIndicator : "";
            }
            return str;
        }

        protected String getTextInternal(Value<?> value) {
            return value.getText();
        }

        public org.eclipse.swt.graphics.Image getImage(Object element) {
            if (this.columnHandler.isElementImageDesired()) {
                IModelElement modelElement = (IModelElement)element;
                SapphireImageCache imageCache = this.columnHandler.getListPropertyEditor().getImageCache();
                return imageCache.getImage(modelElement, modelElement.validate().getSeverity());
            }
            return null;
        }

        public Color getForeground(Object element) {
            Value value = (Value)this.columnHandler.getProperty().invokeGetterMethod(element);
            if (value.getText(false) == null) {
                return Display.getCurrent().getSystemColor(16);
            }
            return null;
        }
    }

    private final class DeleteAction
    extends SelectionBasedAction {
        public DeleteAction() {
            this.setLabel(Resources.deleteActionLabel);
            this.setImageDescriptor(SapphireImageCache.ACTION_DELETE);
            this.setCommandId("org.eclipse.ui.edit.delete");
        }

        protected final Object run(Shell shell) {
            IStructuredContentProvider contentProvider = (IStructuredContentProvider)DefaultListPropertyEditorRenderer.this.tableViewer.getContentProvider();
            List<IModelElement> elementsToDelete = this.getSelectedElements();
            IModelElement elementToSelectAfterDelete = null;
            boolean preferNextElement = true;
            Object[] objectArray = contentProvider.getElements(null);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                boolean toBeDeleted = false;
                for (IModelElement x : elementsToDelete) {
                    if (object != x) continue;
                    toBeDeleted = true;
                    preferNextElement = true;
                    break;
                }
                if (!toBeDeleted && preferNextElement) {
                    elementToSelectAfterDelete = (IModelElement)object;
                    preferNextElement = false;
                }
                ++n2;
            }
            for (IModelElement iModelElement : elementsToDelete) {
                ((IRemovable)iModelElement).remove();
            }
            DefaultListPropertyEditorRenderer.this.refreshOperation.run();
            if (elementToSelectAfterDelete != null) {
                DefaultListPropertyEditorRenderer.this.tableViewer.setSelection((ISelection)new StructuredSelection(elementToSelectAfterDelete));
            }
            return null;
        }

        public boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            return !this.getSelectedElements().isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumPropertyColumnHandler
    extends ColumnHandler {
        private final EnumValueType annotatedEnumeration;
        private final Enum<?>[] enumValues;

        public EnumPropertyColumnHandler(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, SapphirePropertyEditor listPropertyEditor, List<ColumnHandler> allColumnHandlers, SapphirePropertyEditor.ChildPropertyHelper childPropertyHelper, boolean showElementImage) {
            super(context, tableViewer, selectionProvider, listPropertyEditor, allColumnHandlers, childPropertyHelper, showElementImage);
            this.annotatedEnumeration = new EnumValueType(childPropertyHelper.getProperty().getTypeClass());
            this.enumValues = this.annotatedEnumeration.getItems();
        }

        @Override
        protected CellLabelProvider createLabelProvider() {
            return new DefaultColumnLabelProvider(this){

                @Override
                protected String getTextInternal(Value<?> value) {
                    Enum enumItem;
                    String str = null;
                    if (EnumPropertyColumnHandler.this.annotatedEnumeration != null && (enumItem = (Enum)value.getContent(true)) != null) {
                        str = EnumPropertyColumnHandler.this.annotatedEnumeration.getLabel(enumItem, false, CapitalizationType.FIRST_WORD_ONLY, false);
                    }
                    if (str == null) {
                        str = value.getText(true);
                    }
                    return str;
                }
            };
        }

        @Override
        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private ReadOnlyComboBoxCellEditor cellEditor;
                private List<String> cellEditorItems;

                public CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        this.cellEditor = new ReadOnlyComboBoxCellEditor((Composite)EnumPropertyColumnHandler.this.getTable(), new String[0], 12);
                        this.cellEditorItems = new ArrayList<String>();
                    }
                    EnumValueType annotatedEnumeration = EnumPropertyColumnHandler.this.annotatedEnumeration;
                    Enum[] enumValues = EnumPropertyColumnHandler.this.enumValues;
                    Value value = (Value)EnumPropertyColumnHandler.this.getProperty().invokeGetterMethod(element);
                    String stringValue = value.getText(false);
                    boolean needExtraEntry = false;
                    if (stringValue != null && value.getContent(false) == null) {
                        needExtraEntry = true;
                    }
                    String[] items = new String[enumValues.length + (needExtraEntry ? 1 : 0)];
                    this.cellEditorItems.clear();
                    IModelElement modelElement = (IModelElement)element;
                    int i = 0;
                    while (i < enumValues.length) {
                        Enum enumValue = enumValues[i];
                        String enumValueText = ((ValueSerializationService)modelElement.service(ValueSerializationService.class)).encode(EnumPropertyColumnHandler.this.getProperty(), (Object)enumValue);
                        this.cellEditorItems.add(enumValueText);
                        items[i] = annotatedEnumeration.getLabel(enumValue, false, CapitalizationType.FIRST_WORD_ONLY, false);
                        ++i;
                    }
                    if (needExtraEntry) {
                        items[items.length] = stringValue;
                    }
                    this.cellEditor.setItems(items);
                    return this.cellEditor;
                }

                public Object getValue(Object element) {
                    String str = EnumPropertyColumnHandler.this.getPropertyValue((IModelElement)element).getText(false);
                    str = str != null ? str : "";
                    int i = 0;
                    int n = this.cellEditorItems.size();
                    while (i < n) {
                        if (this.cellEditorItems.get(i).equals(str)) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }

                public void setValue(Object element, Object value) {
                    int index = (Integer)value;
                    String str = index == -1 ? null : this.cellEditorItems.get(index);
                    EnumPropertyColumnHandler.this.setPropertyValue((IModelElement)element, str);
                }
            };
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return propertyEditorDefinition.getProperty() instanceof ListProperty;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new DefaultListPropertyEditorRenderer(context, part);
        }
    }

    private final class MoveDownAction
    extends SelectionBasedAction {
        public MoveDownAction(Action.Listener actionListener) {
            this.setLabel(Resources.moveDownActionLabel);
            this.setImageDescriptor(SapphireImageCache.ACTION_MOVE_DOWN);
            this.setCommandId("sapphire.move.down");
            this.addListener(actionListener);
        }

        public boolean isEnabled() {
            if (!super.isEnabled() || this.getSelectedElements().size() != 1 || DefaultListPropertyEditorRenderer.this.tableViewer.getComparator() != null) {
                return false;
            }
            IModelElement modelElement = this.getSelectedElement();
            ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
            return list.indexOf((Object)modelElement) < list.size() - 1;
        }

        protected final Object run(Shell shell) {
            DefaultListPropertyEditorRenderer.this.getList().moveDown(this.getSelectedElement());
            return null;
        }
    }

    private final class MoveUpAction
    extends SelectionBasedAction {
        public MoveUpAction(Action.Listener actionListener) {
            this.setLabel(Resources.moveUpActionLabel);
            this.setImageDescriptor(SapphireImageCache.ACTION_MOVE_UP);
            this.setCommandId("sapphire.move.up");
            this.addListener(actionListener);
        }

        public boolean isEnabled() {
            if (!super.isEnabled() || this.getSelectedElements().size() != 1 || DefaultListPropertyEditorRenderer.this.tableViewer.getComparator() != null) {
                return false;
            }
            IModelElement modelElement = this.getSelectedElement();
            return DefaultListPropertyEditorRenderer.this.getList().indexOf((Object)modelElement) > 0;
        }

        protected final Object run(Shell shell) {
            DefaultListPropertyEditorRenderer.this.getList().moveUp(this.getSelectedElement());
            return null;
        }
    }

    private static final class Resources
    extends NLS {
        public static String addActionLabel;
        public static String deleteActionLabel;
        public static String moveUpActionLabel;
        public static String moveDownActionLabel;
        public static String emptyRowIndicator;

        static {
            Resources.initializeMessages((String)DefaultListPropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SelectionBasedAction
    extends AbstractAction {
        public SelectionBasedAction() {
            DefaultListPropertyEditorRenderer.this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectionBasedAction.this.notifyChangeListeners();
                }
            });
        }

        public IModelElement getSelectedElement() {
            IStructuredSelection sel = (IStructuredSelection)DefaultListPropertyEditorRenderer.this.tableViewer.getSelection();
            if (sel == null) {
                return null;
            }
            return (IModelElement)sel.getFirstElement();
        }

        public List<IModelElement> getSelectedElements() {
            IStructuredSelection sel = (IStructuredSelection)DefaultListPropertyEditorRenderer.this.tableViewer.getSelection();
            ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
            if (sel != null) {
                Iterator itr = sel.iterator();
                while (itr.hasNext()) {
                    elements.add((IModelElement)itr.next());
                }
            }
            return elements;
        }
    }

    public static final class SelectionProvider
    implements ISelectionProvider {
        private final TableViewer tableViewer;
        private final Set<ISelectionChangedListener> listeners;
        private ISelection fakeSelection;

        public SelectionProvider(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
            this.listeners = new CopyOnWriteArraySet<ISelectionChangedListener>();
            this.fakeSelection = null;
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectionProvider.this.handleSelectionChangedEvent(SelectionProvider.this.getSelection());
                }
            });
        }

        public ISelection getSelection() {
            if (this.fakeSelection != null) {
                return this.fakeSelection;
            }
            return this.tableViewer.getSelection();
        }

        public void setSelection(ISelection selection) {
            throw new UnsupportedOperationException();
        }

        public void setFakeSelection(ISelection selection) {
            this.fakeSelection = selection;
            this.handleSelectionChangedEvent(this.getSelection());
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        private void handleSelectionChangedEvent(ISelection selection) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            for (ISelectionChangedListener listener : this.listeners) {
                listener.selectionChanged(event);
            }
        }
    }

    private static final class TableLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private ColumnLabelProvider columnLabelProvider;

        public TableLabelProvider(ColumnLabelProvider columnLabelProvider) {
            this.columnLabelProvider = columnLabelProvider;
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.columnLabelProvider.getText(element);
        }

        public org.eclipse.swt.graphics.Image getColumnImage(Object element, int columnIndex) {
            return this.columnLabelProvider.getImage(element);
        }

        public Color getForeground(Object element, int columnIndex) {
            return this.columnLabelProvider.getForeground(element);
        }

        public Color getBackground(Object element, int columnIndex) {
            return this.columnLabelProvider.getBackground(element);
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private static final class TableSorter
    extends ViewerComparator {
        private final ColumnHandler columnHandler;
        private final int direction;

        public TableSorter(ColumnHandler columnHandler, int direction) {
            this.columnHandler = columnHandler;
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object x, Object y) {
            int result = this.columnHandler.comparePropertyValues((IModelElement)x, (IModelElement)y);
            if (this.direction == 128) {
                result *= -1;
            }
            return result;
        }
    }
}

