/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sapphire.modeling.IExecutableModelElement;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.def.ISapphireWizardDef;
import org.eclipse.sapphire.ui.def.ISapphireWizardPageDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.SapphireStatusDialog;
import org.eclipse.sapphire.ui.swt.SapphireWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireWizard<M extends IExecutableModelElement>
extends Wizard {
    private final M modelElement;
    private final ISapphireWizardDef definition;

    public SapphireWizard(M modelElement, String wizardDefPath) {
        this.modelElement = modelElement;
        this.definition = SapphireUiDefFactory.getWizardDef(wizardDefPath);
        this.setWindowTitle((String)this.definition.getLabel().getContent());
        ImageDescriptor imageDescriptor = (ImageDescriptor)this.definition.getImage().resolve();
        if (imageDescriptor != null) {
            this.setDefaultPageImageDescriptor(imageDescriptor);
        }
        this.setNeedsProgressMonitor(true);
    }

    public final M getModelElement() {
        return this.modelElement;
    }

    public final void addPages() {
        for (ISapphireWizardPageDef pageDef : this.definition.getPageDefs()) {
            SapphireWizardPage page = new SapphireWizardPage((IModelElement)this.modelElement, pageDef);
            this.addPage((IWizardPage)page);
        }
    }

    public final boolean performFinish() {
        final IStatus[] result = new IStatus[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                result[0] = SapphireWizard.this.modelElement.execute(monitor);
            }
        };
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            SapphireUiFrameworkPlugin.log(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        IStatus st = result[0];
        if (st.isOK()) {
            this.performPostFinish();
            return true;
        }
        SapphireStatusDialog.open(this.getShell(), st);
        return false;
    }

    protected void performPostFinish() {
    }

    protected final void openFileEditors(IFile ... files) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file != null && file.isAccessible()) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                }
                ++n2;
            }
        }
    }
}

