/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.calendar.IAttendee;
import org.eclipse.sapphire.samples.calendar.IEvent;
import org.eclipse.sapphire.samples.calendar.IEventAttachment;
import org.eclipse.sapphire.samples.calendar.internal.Attendee;
import org.eclipse.sapphire.samples.calendar.internal.EventAttachment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Event
extends ModelElementForXml
implements IEvent {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_END_TIME = new XmlPath("end-time", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_LOCATION = new XmlPath("location", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_NOTES = new XmlPath("notes", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_START_TIME = new XmlPath("start-time", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_SUBJECT = new XmlPath("subject", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private ModelElementList<IEventAttachment> attachments = null;
    private ModelElementList<IAttendee> attendees = null;
    private Value<String> endTime = null;
    private Value<String> location = null;
    private Value<String> notes = null;
    private Value<String> startTime = null;
    private Value<String> subject = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_END_TIME, PATH_END_TIME);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_LOCATION, PATH_LOCATION);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_NOTES, PATH_NOTES);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_START_TIME, PATH_START_TIME);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_SUBJECT, PATH_SUBJECT);
    }

    public Event(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IEventAttachment> getAttachments() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.attachments == null) {
                this.refresh((ModelProperty)PROP_ATTACHMENTS, true);
            }
            return this.attachments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IAttendee> getAttendees() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.attendees == null) {
                this.refresh((ModelProperty)PROP_ATTENDEES, true);
            }
            return this.attendees;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getEndTime() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.endTime == null) {
                this.refresh((ModelProperty)PROP_END_TIME, true);
            }
            return this.endTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndTime(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_END_TIME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_END_TIME, true);
            if (!Event.equal((String)this.endTime.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_END_TIME, value, true);
                this.refresh((ModelProperty)PROP_END_TIME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getLocation() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.location == null) {
                this.refresh((ModelProperty)PROP_LOCATION, true);
            }
            return this.location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocation(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LOCATION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LOCATION, true);
            if (!Event.equal((String)this.location.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_LOCATION, value, true);
                this.refresh((ModelProperty)PROP_LOCATION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getNotes() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.notes == null) {
                this.refresh((ModelProperty)PROP_NOTES, true);
            }
            return this.notes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotes(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NOTES.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_NOTES, true);
            if (!Event.equal((String)this.notes.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_NOTES, value, true);
                this.refresh((ModelProperty)PROP_NOTES, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStartTime() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.startTime == null) {
                this.refresh((ModelProperty)PROP_START_TIME, true);
            }
            return this.startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartTime(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_START_TIME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_START_TIME, true);
            if (!Event.equal((String)this.startTime.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_START_TIME, value, true);
                this.refresh((ModelProperty)PROP_START_TIME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getSubject() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.subject == null) {
                this.refresh((ModelProperty)PROP_SUBJECT, true);
            }
            return this.subject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubject(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SUBJECT.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_SUBJECT, true);
            if (!Event.equal((String)this.subject.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_SUBJECT, value, true);
                this.refresh((ModelProperty)PROP_SUBJECT, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ATTACHMENTS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ATTACHMENTS);
                if (this.attachments == null && force) {
                    this.attachments = new ModelElementList((IModelElement)this, PROP_ATTACHMENTS);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IEventAttachment.TYPE, "attachment");
                    ModelElementListControllerForXml<IEventAttachment> controller = new ModelElementListControllerForXml<IEventAttachment>(typeToElementName.values()){

                        protected IEventAttachment wrap(XmlElement element) {
                            return new EventAttachment((IModelParticle)this.getList(), (ModelProperty)PROP_ATTACHMENTS, element);
                        }

                        public IEventAttachment createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return Event.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_ATTACHMENTS, this.attachments, new String[0]);
                    this.attachments.init((ModelElementListController)controller);
                }
                if (this.attachments != null && !(notified = this.attachments.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_ATTACHMENTS);
                }
            } else if (property == PROP_ATTENDEES) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ATTENDEES);
                if (this.attendees == null && force) {
                    this.attendees = new ModelElementList((IModelElement)this, PROP_ATTENDEES);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IAttendee.TYPE, "attendee");
                    ModelElementListControllerForXml<IAttendee> controller = new ModelElementListControllerForXml<IAttendee>(typeToElementName.values()){

                        protected IAttendee wrap(XmlElement element) {
                            return new Attendee((IModelParticle)this.getList(), (ModelProperty)PROP_ATTENDEES, element);
                        }

                        public IAttendee createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return Event.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_ATTENDEES, this.attendees, new String[0]);
                    this.attendees.init((ModelElementListController)controller);
                }
                if (this.attendees != null && !(notified = this.attendees.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_ATTENDEES);
                }
            } else if (property == PROP_END_TIME) {
                if (this.endTime != null || force) {
                    Value<String> oldValue = this.endTime;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_END_TIME, false);
                    this.endTime = new Value((IModelElement)this, PROP_END_TIME, PROP_END_TIME.encodeKeywords(val));
                    this.endTime.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_END_TIME);
                    if (oldValue != null) {
                        if (this.endTime.equals(oldValue)) {
                            this.endTime = oldValue;
                        }
                        if (this.endTime != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_END_TIME);
                        }
                    }
                }
            } else if (property == PROP_LOCATION) {
                if (this.location != null || force) {
                    Value<String> oldValue = this.location;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_LOCATION, false);
                    this.location = new Value((IModelElement)this, PROP_LOCATION, PROP_LOCATION.encodeKeywords(val));
                    this.location.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LOCATION);
                    if (oldValue != null) {
                        if (this.location.equals(oldValue)) {
                            this.location = oldValue;
                        }
                        if (this.location != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_LOCATION);
                        }
                    }
                }
            } else if (property == PROP_NOTES) {
                if (this.notes != null || force) {
                    Value<String> oldValue = this.notes;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_NOTES, false);
                    this.notes = new Value((IModelElement)this, PROP_NOTES, PROP_NOTES.encodeKeywords(val));
                    this.notes.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_NOTES);
                    if (oldValue != null) {
                        if (this.notes.equals(oldValue)) {
                            this.notes = oldValue;
                        }
                        if (this.notes != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_NOTES);
                        }
                    }
                }
            } else if (property == PROP_START_TIME) {
                if (this.startTime != null || force) {
                    Value<String> oldValue = this.startTime;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_START_TIME, false);
                    this.startTime = new Value((IModelElement)this, PROP_START_TIME, PROP_START_TIME.encodeKeywords(val));
                    this.startTime.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_START_TIME);
                    if (oldValue != null) {
                        if (this.startTime.equals(oldValue)) {
                            this.startTime = oldValue;
                        }
                        if (this.startTime != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_START_TIME);
                        }
                    }
                }
            } else if (property == PROP_SUBJECT && (this.subject != null || force)) {
                Value<String> oldValue = this.subject;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_SUBJECT, false);
                this.subject = new Value((IModelElement)this, PROP_SUBJECT, PROP_SUBJECT.encodeKeywords(val));
                this.subject.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_SUBJECT);
                if (oldValue != null) {
                    if (this.subject.equals(oldValue)) {
                        this.subject = oldValue;
                    }
                    if (this.subject != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_SUBJECT);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

