/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.ListPropertyCustomBinding;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.NonNullValue;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProvider;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.Validator;
import org.eclipse.sapphire.modeling.validators.UniqueValueValidator;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.annotations.GenerateXmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.ListPropertyXmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.ListPropertyXmlBindingMapping;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.samples.contacts.IAddress;
import org.eclipse.sapphire.samples.contacts.IAssistant;
import org.eclipse.sapphire.samples.contacts.IConnection;
import org.eclipse.sapphire.samples.contacts.IPhoneNumber;
import org.eclipse.sapphire.samples.contacts.IWebSite;
import org.eclipse.sapphire.samples.contacts.internal.ConnectionsListController;
import org.eclipse.sapphire.samples.contacts.internal.ContactCategoryValuesProvider;
import org.eclipse.sapphire.samples.contacts.internal.ContactMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Image(small="org.eclipse.sapphire.samples/images/person.png")
@GenerateXmlBinding
public interface IContact
extends IModelElementForXml,
IRemovable {
    public static final ModelElementType TYPE = new ModelElementType(IContact.class);
    @XmlBinding(path="@name")
    @Label(standard="name")
    @NonNullValue
    @DependsOn(value={"*/Name"})
    @Validator(impl=UniqueValueValidator.class)
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @XmlBinding(path="%category")
    @Label(standard="category")
    @DefaultValue(value="Personal")
    @PossibleValuesProvider(impl=ContactCategoryValuesProvider.class, invalidValueSeverity=0)
    public static final ValueProperty PROP_CATEGORY = new ValueProperty(TYPE, "Category");
    @XmlBinding(path="e-mail")
    @Label(standard="E-Mail")
    public static final ValueProperty PROP_E_MAIL = new ValueProperty(TYPE, "EMail");
    @Type(base=IPhoneNumber.class)
    @ListPropertyXmlBinding(path="phone-numbers", mappings={@ListPropertyXmlBindingMapping(element="phone-number", type=IPhoneNumber.class)})
    @Label(standard="phone numbers")
    public static final ListProperty PROP_PHONE_NUMBERS = new ListProperty(TYPE, "PhoneNumbers");
    @Type(base=IWebSite.class)
    @ListPropertyXmlBinding(path="web-sites", mappings={@ListPropertyXmlBindingMapping(element="web-site", type=IWebSite.class)})
    @Label(standard="web sites")
    public static final ListProperty PROP_WEB_SITES = new ListProperty(TYPE, "WebSites");
    @Type(base=IAddress.class)
    public static final ElementProperty PROP_ADDRESS = new ElementProperty(TYPE, "Address");
    @Type(base=IAssistant.class)
    @XmlBinding(path="assistant")
    @Label(standard="assistant")
    public static final ElementProperty PROP_ASSISTANT = new ElementProperty(TYPE, "Assistant");
    @Label(standard="connections")
    @Type(base=IConnection.class)
    @ListPropertyCustomBinding(impl=ConnectionsListController.class)
    @NoDuplicates
    public static final ListProperty PROP_CONNECTIONS = new ListProperty(TYPE, "Connections");

    public Value<String> getName();

    public void setName(String var1);

    public Value<String> getCategory();

    public void setCategory(String var1);

    public Value<String> getEMail();

    public void setEMail(String var1);

    public ModelElementList<IPhoneNumber> getPhoneNumbers();

    public ModelElementList<IWebSite> getWebSites();

    @DelegateImplementation(value=ContactMethods.class)
    public void removePhoneNumbersByAreaCode(String var1);

    public IAddress getAddress();

    public IAssistant getAssistant();

    public IAssistant getAssistant(boolean var1);

    public ModelElementList<IConnection> getConnections();
}

