/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.BrowseHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class WebSiteUrlBrowseHandler
extends BrowseHandler {
    public String browse(SapphireRenderingContext context) {
        Value value = (Value)this.getProperty().invokeGetterMethod((Object)this.getModelElement());
        String val = value.getText(true);
        val = val == null ? "" : val;
        WebSiteUrlDialog dialog = new WebSiteUrlDialog(context.getShell(), val);
        if (dialog.open() == 0) {
            return dialog.getUrl();
        }
        return null;
    }

    private static class WebSiteUrlDialog
    extends Dialog {
        private String domain = "";
        private String path = "";

        public WebSiteUrlDialog(Shell shell, String url) {
            super(shell);
            int domainStart = url.indexOf("//");
            domainStart = domainStart == -1 ? 0 : (domainStart += 2);
            if (domainStart < url.length()) {
                int domainEnd = url.indexOf(47, domainStart);
                if (domainEnd == -1) {
                    this.domain = url.substring(domainStart);
                } else {
                    this.domain = url.substring(domainStart, domainEnd);
                    int pathStart = domainEnd + 1;
                    if (pathStart < url.length()) {
                        this.path = url.substring(pathStart);
                    }
                }
            }
        }

        public String getUrl() {
            StringBuilder buf = new StringBuilder();
            buf.append("http://");
            buf.append(this.domain);
            if (this.path.length() > 0) {
                buf.append("/");
                buf.append(this.path);
            }
            return buf.toString();
        }

        protected Control createDialogArea(Composite parent) {
            parent.getShell().setText("URL Editor Dialog");
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(composite, 0);
            label.setText("");
            label.setLayoutData((Object)new GridData());
            label = new Label(composite, 0);
            label.setText("domain");
            label.setLayoutData((Object)new GridData());
            label = new Label(composite, 0);
            label.setText("path");
            label.setLayoutData((Object)new GridData());
            label = new Label(composite, 0);
            label.setText("http://");
            label.setLayoutData((Object)new GridData());
            final Text domainNameTextField = new Text(composite, 2048);
            GridData gd = new GridData(768);
            gd.widthHint = 150;
            domainNameTextField.setLayoutData((Object)gd);
            domainNameTextField.setText(this.domain);
            domainNameTextField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WebSiteUrlDialog.this.domain = domainNameTextField.getText().trim();
                }
            });
            final Text pathTextField = new Text(composite, 2048);
            gd = new GridData(768);
            gd.widthHint = 200;
            pathTextField.setLayoutData((Object)gd);
            pathTextField.setText(this.path);
            pathTextField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WebSiteUrlDialog.this.path = pathTextField.getText().trim();
                }
            });
            return composite;
        }
    }
}

