/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.ezbug.internal;

import java.util.Collections;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.ModelForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.samples.ezbug.IBugDatabase;
import org.eclipse.sapphire.samples.ezbug.IBugReport;
import org.eclipse.sapphire.samples.ezbug.internal.BugReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BugDatabase
extends ModelForXml
implements IBugDatabase {
    private ModelElementList<IBugReport> bugReports = null;

    public BugDatabase(ModelStoreForXml modelStore) {
        super(TYPE, modelStore);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerRootModelElement((IModelElement)this);
    }

    protected RootElementController createRootElementController() {
        return new StandardRootElementController(null, null, null, "bug-database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IBugReport> getBugReports() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.bugReports == null) {
                this.refresh((ModelProperty)PROP_BUG_REPORTS, true);
            }
            return this.bugReports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_BUG_REPORTS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_BUG_REPORTS);
                if (this.bugReports == null && force) {
                    this.bugReports = new ModelElementList((IModelElement)this, PROP_BUG_REPORTS);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IBugReport.TYPE, "bug");
                    ModelElementListControllerForXml<IBugReport> controller = new ModelElementListControllerForXml<IBugReport>(typeToElementName.values()){

                        protected IBugReport wrap(XmlElement element) {
                            return new BugReport((IModelParticle)this.getList(), (ModelProperty)PROP_BUG_REPORTS, element);
                        }

                        public IBugReport createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return BugDatabase.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_BUG_REPORTS, this.bugReports, new String[0]);
                    this.bugReports.init((ModelElementListController)controller);
                }
                if (this.bugReports != null && !(notified = this.bugReports.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_BUG_REPORTS);
                }
            }
        }
    }
}

