/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.ezbug.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.ezbug.HardwareType;
import org.eclipse.sapphire.samples.ezbug.IHardwareItem;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HardwareItem
extends ModelElementForXml
implements IHardwareItem {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_DESCRIPTION = new XmlPath("description", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_ITEM_MODEL = new XmlPath("model", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_MAKE = new XmlPath("make", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_TYPE = new XmlPath("type", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<String> description = null;
    private Value<String> itemModel = null;
    private Value<String> make = null;
    private Value<HardwareType> type = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_DESCRIPTION, PATH_DESCRIPTION);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ITEM_MODEL, PATH_ITEM_MODEL);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_MAKE, PATH_MAKE);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_TYPE, PATH_TYPE);
    }

    public HardwareItem(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDescription() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.description == null) {
                this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            }
            return this.description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DESCRIPTION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            if (!HardwareItem.equal((String)this.description.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_DESCRIPTION, value, true);
                this.refresh((ModelProperty)PROP_DESCRIPTION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getItemModel() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.itemModel == null) {
                this.refresh((ModelProperty)PROP_ITEM_MODEL, true);
            }
            return this.itemModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItemModel(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ITEM_MODEL.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_ITEM_MODEL, true);
            if (!HardwareItem.equal((String)this.itemModel.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_ITEM_MODEL, value, true);
                this.refresh((ModelProperty)PROP_ITEM_MODEL, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getMake() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.make == null) {
                this.refresh((ModelProperty)PROP_MAKE, true);
            }
            return this.make;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMake(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_MAKE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_MAKE, true);
            if (!HardwareItem.equal((String)this.make.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_MAKE, value, true);
                this.refresh((ModelProperty)PROP_MAKE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<HardwareType> getType() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.type == null) {
                this.refresh((ModelProperty)PROP_TYPE, true);
            }
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setType(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_TYPE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_TYPE, true);
            if (!HardwareItem.equal((String)this.type.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_TYPE, value, true);
                this.refresh((ModelProperty)PROP_TYPE, false);
            }
        }
    }

    @Override
    public void setType(HardwareType value) {
        this.setType(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_TYPE, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_DESCRIPTION) {
                if (this.description != null || force) {
                    Value<String> oldValue = this.description;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_DESCRIPTION, false);
                    this.description = new Value((IModelElement)this, PROP_DESCRIPTION, PROP_DESCRIPTION.encodeKeywords(val));
                    this.description.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_DESCRIPTION);
                    if (oldValue != null) {
                        if (this.description.equals(oldValue)) {
                            this.description = oldValue;
                        }
                        if (this.description != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_DESCRIPTION);
                        }
                    }
                }
            } else if (property == PROP_ITEM_MODEL) {
                if (this.itemModel != null || force) {
                    Value<String> oldValue = this.itemModel;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_ITEM_MODEL, false);
                    this.itemModel = new Value((IModelElement)this, PROP_ITEM_MODEL, PROP_ITEM_MODEL.encodeKeywords(val));
                    this.itemModel.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ITEM_MODEL);
                    if (oldValue != null) {
                        if (this.itemModel.equals(oldValue)) {
                            this.itemModel = oldValue;
                        }
                        if (this.itemModel != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_ITEM_MODEL);
                        }
                    }
                }
            } else if (property == PROP_MAKE) {
                if (this.make != null || force) {
                    Value<String> oldValue = this.make;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_MAKE, false);
                    this.make = new Value((IModelElement)this, PROP_MAKE, PROP_MAKE.encodeKeywords(val));
                    this.make.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_MAKE);
                    if (oldValue != null) {
                        if (this.make.equals(oldValue)) {
                            this.make = oldValue;
                        }
                        if (this.make != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_MAKE);
                        }
                    }
                }
            } else if (property == PROP_TYPE && (this.type != null || force)) {
                Value<HardwareType> oldValue = this.type;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_TYPE, false);
                this.type = new Value((IModelElement)this, PROP_TYPE, PROP_TYPE.encodeKeywords(val));
                this.type.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_TYPE);
                if (oldValue != null) {
                    if (this.type.equals(oldValue)) {
                        this.type = oldValue;
                    }
                    if (this.type != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_TYPE);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

