/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.gallery.IBigDecimalValueGallery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigDecimalValueGallery
extends ModelElementForXml
implements IBigDecimalValueGallery {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_POSITIVE = new XmlPath("positive", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_RANGE_CONSTRAINED_WITH_DEFAULT = new XmlPath("range-constrained-with-default", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_SIMPLE = new XmlPath("simple", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<BigDecimal> positive = null;
    private Value<BigDecimal> rangeConstrainedWithDefault = null;
    private Value<BigDecimal> simple = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_POSITIVE, PATH_POSITIVE);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, PATH_RANGE_CONSTRAINED_WITH_DEFAULT);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_SIMPLE, PATH_SIMPLE);
    }

    public BigDecimalValueGallery(IModelParticle parent, ModelProperty parentProperty) {
        super(TYPE, parent, parentProperty, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<BigDecimal> getPositive() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.positive == null) {
                this.refresh((ModelProperty)PROP_POSITIVE, true);
            }
            return this.positive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPositive(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_POSITIVE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_POSITIVE, true);
            if (!BigDecimalValueGallery.equal((String)this.positive.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_POSITIVE, value, true);
                this.refresh((ModelProperty)PROP_POSITIVE, false);
            }
        }
    }

    @Override
    public void setPositive(BigDecimal value) {
        this.setPositive(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_POSITIVE, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<BigDecimal> getRangeConstrainedWithDefault() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.rangeConstrainedWithDefault == null) {
                this.refresh((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, true);
            }
            return this.rangeConstrainedWithDefault;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRangeConstrainedWithDefault(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_RANGE_CONSTRAINED_WITH_DEFAULT.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, true);
            if (!BigDecimalValueGallery.equal((String)this.rangeConstrainedWithDefault.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_RANGE_CONSTRAINED_WITH_DEFAULT, value, true);
                this.refresh((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, false);
            }
        }
    }

    @Override
    public void setRangeConstrainedWithDefault(BigDecimal value) {
        this.setRangeConstrainedWithDefault(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_RANGE_CONSTRAINED_WITH_DEFAULT, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<BigDecimal> getSimple() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.simple == null) {
                this.refresh((ModelProperty)PROP_SIMPLE, true);
            }
            return this.simple;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSimple(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SIMPLE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_SIMPLE, true);
            if (!BigDecimalValueGallery.equal((String)this.simple.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_SIMPLE, value, true);
                this.refresh((ModelProperty)PROP_SIMPLE, false);
            }
        }
    }

    @Override
    public void setSimple(BigDecimal value) {
        this.setSimple(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_SIMPLE, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_POSITIVE) {
                if (this.positive != null || force) {
                    Value<BigDecimal> oldValue = this.positive;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_POSITIVE, false);
                    this.positive = new Value((IModelElement)this, PROP_POSITIVE, PROP_POSITIVE.encodeKeywords(val));
                    this.positive.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_POSITIVE);
                    if (oldValue != null) {
                        if (this.positive.equals(oldValue)) {
                            this.positive = oldValue;
                        }
                        if (this.positive != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_POSITIVE);
                        }
                    }
                }
            } else if (property == PROP_RANGE_CONSTRAINED_WITH_DEFAULT) {
                if (this.rangeConstrainedWithDefault != null || force) {
                    Value<BigDecimal> oldValue = this.rangeConstrainedWithDefault;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_RANGE_CONSTRAINED_WITH_DEFAULT, false);
                    this.rangeConstrainedWithDefault = new Value((IModelElement)this, PROP_RANGE_CONSTRAINED_WITH_DEFAULT, PROP_RANGE_CONSTRAINED_WITH_DEFAULT.encodeKeywords(val));
                    this.rangeConstrainedWithDefault.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT);
                    if (oldValue != null) {
                        if (this.rangeConstrainedWithDefault.equals(oldValue)) {
                            this.rangeConstrainedWithDefault = oldValue;
                        }
                        if (this.rangeConstrainedWithDefault != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT);
                        }
                    }
                }
            } else if (property == PROP_SIMPLE && (this.simple != null || force)) {
                Value<BigDecimal> oldValue = this.simple;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_SIMPLE, false);
                this.simple = new Value((IModelElement)this, PROP_SIMPLE, PROP_SIMPLE.encodeKeywords(val));
                this.simple.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_SIMPLE);
                if (oldValue != null) {
                    if (this.simple.equals(oldValue)) {
                        this.simple = oldValue;
                    }
                    if (this.simple != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_SIMPLE);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlElement getXmlElement(boolean createIfNecessary) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement root = ((IModelElementForXml)this.getParent()).getXmlElement(createIfNecessary);
            if (root != null) {
                root = root.getChildElement("big-decimal", createIfNecessary);
            }
            return root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

