/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.gallery.IBrowseSupportGallery;
import org.eclipse.sapphire.samples.gallery.IBrowseSupportGalleryListEntry;
import org.eclipse.sapphire.samples.gallery.internal.BrowseSupportGalleryListEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowseSupportGallery
extends ModelElementForXml
implements IBrowseSupportGallery {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_ABSOLUTE_FILE_PATH = new XmlPath("absolute-file-path", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_ABSOLUTE_FOLDER_PATH = new XmlPath("absolute-folder-path", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_MULTI_OPTION_PATH = new XmlPath("multi-option-path", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_RELATIVE_FILE_PATH = new XmlPath("relative-folder-path", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<IPath> absoluteFilePath = null;
    private Value<IPath> absoluteFolderPath = null;
    private ModelElementList<IBrowseSupportGalleryListEntry> list = null;
    private Value<IPath> multiOptionPath = null;
    private Value<IPath> relativeFilePath = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ABSOLUTE_FILE_PATH, PATH_ABSOLUTE_FILE_PATH);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ABSOLUTE_FOLDER_PATH, PATH_ABSOLUTE_FOLDER_PATH);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_MULTI_OPTION_PATH, PATH_MULTI_OPTION_PATH);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_RELATIVE_FILE_PATH, PATH_RELATIVE_FILE_PATH);
    }

    public BrowseSupportGallery(IModelParticle parent, ModelProperty parentProperty) {
        super(TYPE, parent, parentProperty, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<IPath> getAbsoluteFilePath() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.absoluteFilePath == null) {
                this.refresh((ModelProperty)PROP_ABSOLUTE_FILE_PATH, true);
            }
            return this.absoluteFilePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAbsoluteFilePath(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ABSOLUTE_FILE_PATH.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_ABSOLUTE_FILE_PATH, true);
            if (!BrowseSupportGallery.equal((String)this.absoluteFilePath.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_ABSOLUTE_FILE_PATH, value, true);
                this.refresh((ModelProperty)PROP_ABSOLUTE_FILE_PATH, false);
            }
        }
    }

    @Override
    public void setAbsoluteFilePath(IPath value) {
        this.setAbsoluteFilePath(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_ABSOLUTE_FILE_PATH, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<IPath> getAbsoluteFolderPath() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.absoluteFolderPath == null) {
                this.refresh((ModelProperty)PROP_ABSOLUTE_FOLDER_PATH, true);
            }
            return this.absoluteFolderPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAbsoluteFolderPath(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ABSOLUTE_FOLDER_PATH.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_ABSOLUTE_FOLDER_PATH, true);
            if (!BrowseSupportGallery.equal((String)this.absoluteFolderPath.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_ABSOLUTE_FOLDER_PATH, value, true);
                this.refresh((ModelProperty)PROP_ABSOLUTE_FOLDER_PATH, false);
            }
        }
    }

    @Override
    public void setAbsoluteFolderPath(IPath value) {
        this.setAbsoluteFolderPath(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_ABSOLUTE_FOLDER_PATH, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IBrowseSupportGalleryListEntry> getList() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.list == null) {
                this.refresh((ModelProperty)PROP_LIST, true);
            }
            return this.list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<IPath> getMultiOptionPath() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.multiOptionPath == null) {
                this.refresh((ModelProperty)PROP_MULTI_OPTION_PATH, true);
            }
            return this.multiOptionPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMultiOptionPath(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_MULTI_OPTION_PATH.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_MULTI_OPTION_PATH, true);
            if (!BrowseSupportGallery.equal((String)this.multiOptionPath.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_MULTI_OPTION_PATH, value, true);
                this.refresh((ModelProperty)PROP_MULTI_OPTION_PATH, false);
            }
        }
    }

    @Override
    public void setMultiOptionPath(IPath value) {
        this.setMultiOptionPath(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_MULTI_OPTION_PATH, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<IPath> getRelativeFilePath() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.relativeFilePath == null) {
                this.refresh((ModelProperty)PROP_RELATIVE_FILE_PATH, true);
            }
            return this.relativeFilePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRelativeFilePath(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_RELATIVE_FILE_PATH.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_RELATIVE_FILE_PATH, true);
            if (!BrowseSupportGallery.equal((String)this.relativeFilePath.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_RELATIVE_FILE_PATH, value, true);
                this.refresh((ModelProperty)PROP_RELATIVE_FILE_PATH, false);
            }
        }
    }

    @Override
    public void setRelativeFilePath(IPath value) {
        this.setRelativeFilePath(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_RELATIVE_FILE_PATH, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ABSOLUTE_FILE_PATH) {
                if (this.absoluteFilePath != null || force) {
                    Value<IPath> oldValue = this.absoluteFilePath;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_ABSOLUTE_FILE_PATH, false);
                    this.absoluteFilePath = new Value((IModelElement)this, PROP_ABSOLUTE_FILE_PATH, PROP_ABSOLUTE_FILE_PATH.encodeKeywords(val));
                    this.absoluteFilePath.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ABSOLUTE_FILE_PATH);
                    if (oldValue != null) {
                        if (this.absoluteFilePath.equals(oldValue)) {
                            this.absoluteFilePath = oldValue;
                        }
                        if (this.absoluteFilePath != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_ABSOLUTE_FILE_PATH);
                        }
                    }
                }
            } else if (property == PROP_ABSOLUTE_FOLDER_PATH) {
                if (this.absoluteFolderPath != null || force) {
                    Value<IPath> oldValue = this.absoluteFolderPath;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_ABSOLUTE_FOLDER_PATH, false);
                    this.absoluteFolderPath = new Value((IModelElement)this, PROP_ABSOLUTE_FOLDER_PATH, PROP_ABSOLUTE_FOLDER_PATH.encodeKeywords(val));
                    this.absoluteFolderPath.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ABSOLUTE_FOLDER_PATH);
                    if (oldValue != null) {
                        if (this.absoluteFolderPath.equals(oldValue)) {
                            this.absoluteFolderPath = oldValue;
                        }
                        if (this.absoluteFolderPath != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_ABSOLUTE_FOLDER_PATH);
                        }
                    }
                }
            } else if (property == PROP_LIST) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LIST);
                if (this.list == null && force) {
                    this.list = new ModelElementList((IModelElement)this, PROP_LIST);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IBrowseSupportGalleryListEntry.TYPE, "list-entry");
                    ModelElementListControllerForXml<IBrowseSupportGalleryListEntry> controller = new ModelElementListControllerForXml<IBrowseSupportGalleryListEntry>(typeToElementName.values()){

                        protected IBrowseSupportGalleryListEntry wrap(XmlElement element) {
                            return new BrowseSupportGalleryListEntry((IModelParticle)this.getList(), (ModelProperty)PROP_LIST, element);
                        }

                        public IBrowseSupportGalleryListEntry createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return BrowseSupportGallery.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_LIST, this.list, new String[0]);
                    this.list.init((ModelElementListController)controller);
                }
                if (this.list != null && !(notified = this.list.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_LIST);
                }
            } else if (property == PROP_MULTI_OPTION_PATH) {
                if (this.multiOptionPath != null || force) {
                    Value<IPath> oldValue = this.multiOptionPath;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_MULTI_OPTION_PATH, false);
                    this.multiOptionPath = new Value((IModelElement)this, PROP_MULTI_OPTION_PATH, PROP_MULTI_OPTION_PATH.encodeKeywords(val));
                    this.multiOptionPath.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_MULTI_OPTION_PATH);
                    if (oldValue != null) {
                        if (this.multiOptionPath.equals(oldValue)) {
                            this.multiOptionPath = oldValue;
                        }
                        if (this.multiOptionPath != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_MULTI_OPTION_PATH);
                        }
                    }
                }
            } else if (property == PROP_RELATIVE_FILE_PATH && (this.relativeFilePath != null || force)) {
                Value<IPath> oldValue = this.relativeFilePath;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_RELATIVE_FILE_PATH, false);
                this.relativeFilePath = new Value((IModelElement)this, PROP_RELATIVE_FILE_PATH, PROP_RELATIVE_FILE_PATH.encodeKeywords(val));
                this.relativeFilePath.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_RELATIVE_FILE_PATH);
                if (oldValue != null) {
                    if (this.relativeFilePath.equals(oldValue)) {
                        this.relativeFilePath = oldValue;
                    }
                    if (this.relativeFilePath != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_RELATIVE_FILE_PATH);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlElement getXmlElement(boolean createIfNecessary) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement root = ((IModelElementForXml)this.getParent()).getXmlElement(createIfNecessary);
            return root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

