/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.zoo.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.samples.zoo.IAnimal;
import org.eclipse.sapphire.samples.zoo.IAnimalCountForTypeEntry;
import org.eclipse.sapphire.samples.zoo.IStats;
import org.eclipse.sapphire.samples.zoo.IZooModel;
import org.eclipse.sapphire.samples.zoo.internal.AnimalCountForTypeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Stats
extends ModelElementForXml
implements IStats {
    public ModelElementList<IAnimalCountForTypeEntry> animalsCountByType;

    public Stats(IModelElement parentElement, ModelProperty parentProperty) {
        super(TYPE, (IModelParticle)parentElement, parentProperty, null);
    }

    @Override
    public Value<Integer> getAnimalsCount() {
        int count = ((IZooModel)this.model).getAnimals().size();
        return new Value((IModelElement)this, PROP_ANIMALS_COUNT, String.valueOf(count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IAnimalCountForTypeEntry> getAnimalsCountByType() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.animalsCountByType == null) {
                ModelElementListController<IAnimalCountForTypeEntry> controller = new ModelElementListController<IAnimalCountForTypeEntry>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public List<IAnimalCountForTypeEntry> refresh(List<IAnimalCountForTypeEntry> contents) {
                        IModel iModel = Stats.this.getModel();
                        synchronized (iModel) {
                            TreeMap<String, Integer> counts = new TreeMap<String, Integer>();
                            for (IAnimal animal : ((IZooModel)Stats.this.getModel()).getAnimals()) {
                                String type;
                                Integer c = (Integer)counts.get(type = animal.getModelElementType().getLabel(false, CapitalizationType.FIRST_WORD_ONLY, false));
                                counts.put(type, c == null ? 1 : c + 1);
                            }
                            ArrayList<IAnimalCountForTypeEntry> newContents = new ArrayList<IAnimalCountForTypeEntry>();
                            for (Map.Entry entry : counts.entrySet()) {
                                String type = (String)entry.getKey();
                                Integer count = (Integer)entry.getValue();
                                IAnimalCountForTypeEntry x = null;
                                for (IAnimalCountForTypeEntry y : contents) {
                                    if (!type.equals(y.getType().getContent()) || !count.equals(y.getCount().getContent())) continue;
                                    x = y;
                                }
                                if (x == null) {
                                    x = new AnimalCountForTypeEntry((IModelElement)Stats.this, (ModelProperty)PROP_ANIMALS_COUNT_BY_TYPE, type, count);
                                }
                                newContents.add(x);
                            }
                            return newContents;
                        }
                    }
                };
                this.animalsCountByType = new ModelElementList((IModelElement)this, PROP_ANIMALS_COUNT_BY_TYPE);
                controller.init((IModelElement)this, PROP_ANIMALS_COUNT_BY_TYPE, this.animalsCountByType, new String[0]);
                this.animalsCountByType.init((ModelElementListController)controller);
                return this.animalsCountByType;
            }
            this.animalsCountByType.refresh();
            return this.animalsCountByType;
        }
    }
}

