/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.zoo.internal;

import java.util.Collections;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.samples.zoo.IAnimalEnclosure;
import org.eclipse.sapphire.samples.zoo.IRestroomBuilding;
import org.eclipse.sapphire.samples.zoo.IStructure;
import org.eclipse.sapphire.samples.zoo.IZooModel;
import org.eclipse.sapphire.samples.zoo.internal.AnimalEnclosure;
import org.eclipse.sapphire.samples.zoo.internal.RestroomBuilding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructuresModelElementListController
extends ModelElementListControllerForXml<IStructure> {
    private static final String EL_STRUCTURES = "structures";
    private static final String EL_STRUCTURE = "structure";
    private static final String EL_ANIMAL_ENCLOSURE = "animal-enclosure";
    private static final String EL_RESTROOM_BUILDING = "restroom-building";

    public StructuresModelElementListController() {
        super(Collections.singleton(EL_STRUCTURE));
    }

    public IStructure createNewElement(ModelElementType type) {
        this.validateEdit();
        XmlElement element = this.getParentXmlElement(true).addChildElement(EL_STRUCTURE);
        if (type == IAnimalEnclosure.TYPE) {
            element.addChildElement(EL_ANIMAL_ENCLOSURE);
        } else if (type == IRestroomBuilding.TYPE) {
            element.addChildElement(EL_RESTROOM_BUILDING);
        } else {
            throw new IllegalArgumentException();
        }
        return this.wrap(element);
    }

    protected IStructure wrap(XmlElement element) {
        if (element.getChildElement(EL_ANIMAL_ENCLOSURE, false) != null) {
            return new AnimalEnclosure((IModelParticle)this.getList(), (ModelProperty)IZooModel.PROP_STRUCTURES, element);
        }
        if (element.getChildElement(EL_RESTROOM_BUILDING, false) != null) {
            return new RestroomBuilding((IModelParticle)this.getList(), (ModelProperty)IZooModel.PROP_STRUCTURES, element);
        }
        return new AnimalEnclosure((IModelParticle)this.getList(), (ModelProperty)IZooModel.PROP_STRUCTURES, element);
    }

    protected XmlElement getParentXmlElement(boolean createIfNecessary) {
        IModelElementForXml listParent = (IModelElementForXml)this.getModelElement();
        XmlElement parent = listParent.getXmlElement(createIfNecessary);
        if (parent != null) {
            parent = parent.getChildElement(EL_STRUCTURES, createIfNecessary);
        }
        return parent;
    }
}

