/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;

public final class ElementProperty
extends ModelProperty {
    private final Method getterWithCreateParam;

    public ElementProperty(ModelElementType type, String propertyName) {
        this(type, propertyName, null);
    }

    public ElementProperty(ModelElementType type, ElementProperty baseProperty) {
        this(type, baseProperty.getName(), baseProperty);
    }

    private ElementProperty(ModelElementType type, String propertyName, ElementProperty baseProperty) {
        super(type, propertyName, baseProperty);
        String getterName = this.getGetterMethod().getName();
        Method getterWithCreateParam = null;
        Object[] expectedParameterTypes = new Class[]{Boolean.TYPE};
        Method[] methodArray = type.getModelElementClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(getterName) && Arrays.equals(method.getParameterTypes(), expectedParameterTypes)) {
                getterWithCreateParam = method;
                break;
            }
            ++n2;
        }
        this.getterWithCreateParam = getterWithCreateParam;
    }

    public Object invokeGetterMethod(Object model, boolean createIfNecessary) {
        if (!createIfNecessary) {
            return this.invokeGetterMethod(model);
        }
        try {
            return this.getterWithCreateParam.invoke(model, createIfNecessary);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

