/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

public class ValueKeyword {
    private final String keyword;
    private final String value;
    private final String displayString;

    public ValueKeyword(String keyword, String value) {
        this.keyword = keyword;
        this.value = value;
        this.displayString = this.createDisplayString(keyword, value);
    }

    public final String getKeyword() {
        return this.keyword;
    }

    public final String getValue() {
        return this.value;
    }

    public final String decode(String str) {
        if (str != null && str.equals(this.keyword)) {
            return this.value;
        }
        return str;
    }

    public final String encode(String str) {
        if (str != null && str.equals(this.value)) {
            return this.keyword;
        }
        return str;
    }

    public final String toDisplayString() {
        return this.displayString;
    }

    protected String createDisplayString(String keyword, String value) {
        StringBuilder buf = new StringBuilder();
        buf.append(keyword);
        buf.append(" (");
        buf.append(value);
        buf.append(")");
        return buf.toString();
    }

    public final String toString() {
        return this.keyword;
    }
}

