/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations.processor;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalizeStringResourcesProcessor {
    public void process(AnnotationProcessorEnvironment env) {
        for (TypeDeclaration type : ExternalizeStringResourcesProcessor.getAnnotatedTypes(env)) {
            Properties resources = new Properties();
            ExternalizeStringResourcesProcessor.addResources(resources, "$type$", (Label)type.getAnnotation(Label.class));
            for (FieldDeclaration field : type.getFields()) {
                String fieldName = field.getSimpleName();
                if (fieldName == null) continue;
                if (fieldName.startsWith("PROP_")) {
                    NamedValues namedValuesAnnotation;
                    String propName = ExternalizeStringResourcesProcessor.getPropertyName(field);
                    Label labelAnnotation = (Label)field.getAnnotation(Label.class);
                    if (labelAnnotation != null) {
                        ExternalizeStringResourcesProcessor.addResources(resources, propName, labelAnnotation);
                    }
                    if ((namedValuesAnnotation = (NamedValues)field.getAnnotation(NamedValues.class)) == null) continue;
                    resources.put(String.valueOf(propName) + ".arbitraryValue", namedValuesAnnotation.arbitraryValueLabel());
                    NamedValues.NamedValue[] namedValueArray = namedValuesAnnotation.namedValues();
                    int n = namedValueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        NamedValues.NamedValue val = namedValueArray[n2];
                        resources.put(String.valueOf(propName) + ".namedValue." + val.value(), val.label());
                        ++n2;
                    }
                    continue;
                }
                Label labelAnnotation = (Label)field.getAnnotation(Label.class);
                if (labelAnnotation == null) continue;
                ExternalizeStringResourcesProcessor.addResources(resources, fieldName, labelAnnotation);
            }
            if (resources.isEmpty()) continue;
            String pkg = type.getPackage().getQualifiedName();
            String relpath = String.valueOf(type.getSimpleName()) + ".properties";
            PrintWriter pw = null;
            try {
                try {
                    pw = env.getFiler().createTextFile(Filer.Location.CLASS_TREE, pkg, new File(relpath), null);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    resources.store(baos, null);
                    String s = baos.toString();
                    pw.print(s);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (pw == null) continue;
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (pw == null) continue;
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
    }

    private static Set<TypeDeclaration> getAnnotatedTypes(AnnotationProcessorEnvironment env) {
        HashSet<TypeDeclaration> annotatedTypes = new HashSet<TypeDeclaration>();
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)env.getTypeDeclaration(Label.class.getName());
        if (annotationDeclaration == null) {
            return annotatedTypes;
        }
        Collection annotatedDeclarations = env.getDeclarationsAnnotatedWith(annotationDeclaration);
        if (annotatedDeclarations == null) {
            return annotatedTypes;
        }
        for (Declaration decl : annotatedDeclarations) {
            for (AnnotationMirror annotation : decl.getAnnotationMirrors()) {
                if (!annotation.getAnnotationType().getDeclaration().getQualifiedName().equals(Label.class.getName())) continue;
                if (decl instanceof TypeDeclaration) {
                    annotatedTypes.add((TypeDeclaration)decl);
                    continue;
                }
                if (decl instanceof FieldDeclaration) {
                    annotatedTypes.add(((FieldDeclaration)decl).getDeclaringType());
                    continue;
                }
                throw new IllegalStateException(decl.getClass().getName());
            }
        }
        return annotatedTypes;
    }

    private static void addResources(Properties resources, String entityName, Label labelAnnotation) {
        if (labelAnnotation != null) {
            String fullLabel;
            String standardLabel = labelAnnotation.standard();
            if (standardLabel.length() > 0) {
                resources.put(String.valueOf(entityName) + ".standard", standardLabel);
            }
            if ((fullLabel = labelAnnotation.full()).length() > 0) {
                resources.put(String.valueOf(entityName) + ".full", fullLabel);
            }
        }
    }

    private static final String getPropertyName(FieldDeclaration propField) {
        String propFieldName = propField.getSimpleName();
        StringBuilder buf = new StringBuilder();
        boolean seenFirstSegment = false;
        String[] stringArray = propFieldName.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (seenFirstSegment) {
                buf.append(segment.charAt(0));
                buf.append(segment.substring(1).toLowerCase());
            } else {
                seenFirstSegment = true;
            }
            ++n2;
        }
        return buf.toString();
    }
}

