/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations.processor;

import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.Model;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelStore;
import org.eclipse.sapphire.modeling.annotations.GenerateStub;
import org.eclipse.sapphire.modeling.annotations.processor.GenerateModelElementProcessor;
import org.eclipse.sapphire.modeling.annotations.processor.util.AccessModifier;
import org.eclipse.sapphire.modeling.annotations.processor.util.Body;
import org.eclipse.sapphire.modeling.annotations.processor.util.ClassModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.MethodModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.MethodParameterModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.TypeReference;

public final class GenerateStubProcessor
extends GenerateModelElementProcessor {
    protected void preProcess(InterfaceDeclaration elInterface, ClassModel elImplClass) {
        String simpleName = elInterface.getSimpleName().substring(1);
        String defaultPackageName = String.valueOf(elInterface.getPackage().getQualifiedName()) + ".internal";
        GenerateStub generateStubAnnotation = (GenerateStub)elInterface.getAnnotation(GenerateStub.class);
        String packageName = generateStubAnnotation.packageName();
        if (packageName.length() == 0) {
            packageName = defaultPackageName;
        }
        elImplClass.setName(new TypeReference(packageName, String.valueOf(simpleName) + "Stub"));
        elImplClass.setAbstract(true);
        elImplClass.addInterface(new TypeReference(elInterface.getQualifiedName()));
        MethodModel c = elImplClass.addConstructor();
        if (GenerateStubProcessor.isInstanceOf((TypeDeclaration)elInterface, IModel.class.getName())) {
            elImplClass.setBaseClass(new TypeReference(Model.class.getName()));
            c.addParameter(new MethodParameterModel("modelStore", ModelStore.class));
            c.getBody().append("super( TYPE, modelStore );\n");
        } else {
            elImplClass.setBaseClass(new TypeReference(ModelElement.class.getName()));
            c.addParameter(new MethodParameterModel("parent", IModelParticle.class));
            c.addParameter(new MethodParameterModel("parentProperty", ModelProperty.class));
            c.getBody().append("super( TYPE, parent, parentProperty );");
        }
    }

    protected void generateRemoveMethodBody(InterfaceDeclaration elInterface, ClassModel elImplClass, Body removeMethodBody) {
        removeMethodBody.append("validateEdit();");
        removeMethodBody.append("doRemove();");
        MethodModel drm = elImplClass.addMethod("doRemove");
        drm.setAccessModifier(AccessModifier.PROTECTED);
        drm.setAbstract(true);
    }

    protected void generateValuePropertyReadLogic(InterfaceDeclaration elInterface, ClassModel elImplClass, GenerateModelElementProcessor.PropertyFieldDeclaration property, Body mb) {
        mb.append("final String val = read#1();", property.propertyName);
        MethodModel rm = elImplClass.addMethod("read" + property.propertyName);
        rm.setAbstract(true);
        rm.setAccessModifier(AccessModifier.PROTECTED);
        rm.setReturnType(String.class);
    }

    protected void generateValuePropertyWriteLogic(InterfaceDeclaration elInterface, ClassModel elImplClass, GenerateModelElementProcessor.PropertyFieldDeclaration property, Body mb) {
        mb.append("write#1( value );", property.propertyName);
        MethodModel wm = elImplClass.addMethod("write" + property.propertyName);
        wm.setAbstract(true);
        wm.setAccessModifier(AccessModifier.PROTECTED);
        wm.addParameter(new MethodParameterModel("value", String.class));
    }

    protected void generateElementPropertyRefreshLogic(InterfaceDeclaration elInterface, ClassModel elImplClass, GenerateModelElementProcessor.PropertyFieldDeclaration property, Body mb) {
        mb.append("element = refresh#1();", property.propertyName);
        TypeReference type = (TypeReference)property.getData("element.type");
        MethodModel rm = elImplClass.addMethod("refresh" + property.propertyName);
        rm.setAbstract(true);
        rm.setAccessModifier(AccessModifier.PROTECTED);
        rm.setReturnType(type);
    }

    protected void generateElementPropertyCreateLogic(InterfaceDeclaration elInterface, ClassModel elImplClass, GenerateModelElementProcessor.PropertyFieldDeclaration property, Body mb) {
        mb.append("create#1();", property.propertyName);
        MethodModel cm = elImplClass.addMethod("create" + property.propertyName);
        cm.setAbstract(true);
        cm.setAccessModifier(AccessModifier.PROTECTED);
        cm.setReturnType(TypeReference.VOID_TYPE);
    }

    protected void generateListPropertyInitLogic(InterfaceDeclaration elInterface, ClassModel elImplClass, GenerateModelElementProcessor.PropertyFieldDeclaration property, Body mb) {
        String variableName = (String)property.getData("variable.name");
        TypeReference listType = (TypeReference)property.getData("list.type");
        mb.append("this.#1 = init#2();", variableName, property.propertyName);
        MethodModel im = elImplClass.addMethod("init" + property.propertyName);
        im.setAbstract(true);
        im.setAccessModifier(AccessModifier.PROTECTED);
        im.setReturnType(listType);
    }
}

