/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.extensibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.sapphire.modeling.serialization.ValueSerializerImpl;
import org.eclipse.sapphire.modeling.util.internal.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializersExtensionPoint {
    private static final String EL_VALUE_SERIALIZER = "value-serializer";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_IMPL = "impl";
    private static final SerializerRecord BAD_SERIALIZER_RECORD = new SerializerRecord();
    private static List<SerializerRecord> serializers = null;
    private static Map<Class<?>, SerializerRecord> cachedSerializerLookups = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ValueSerializerImpl<?> getSerializer(Class<?> type) {
        SerializersExtensionPoint.initialize();
        SerializerRecord serializerRecord = null;
        Class<SerializersExtensionPoint> clazz = SerializersExtensionPoint.class;
        synchronized (SerializersExtensionPoint.class) {
            serializerRecord = cachedSerializerLookups.get(type);
            if (serializerRecord == null) {
                for (SerializerRecord rec : serializers) {
                    if (!rec.typeClass.isAssignableFrom(type)) continue;
                    serializerRecord = rec;
                    cachedSerializerLookups.put(type, rec);
                    break;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ValueSerializerImpl serializer = null;
            if (serializerRecord == null || serializerRecord == BAD_SERIALIZER_RECORD || (serializer = PluginUtil.instantiate(serializerRecord.declaringBundleId, serializerRecord.implClass)) != null) return serializer;
            Class<SerializersExtensionPoint> clazz2 = SerializersExtensionPoint.class;
            synchronized (SerializersExtensionPoint.class) {
                cachedSerializerLookups.put(type, BAD_SERIALIZER_RECORD);
                serializers.remove(serializerRecord);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return serializer;
            }
        }
    }

    private static synchronized void initialize() {
        if (serializers == null) {
            serializers = new ArrayList<SerializerRecord>();
            cachedSerializerLookups = new HashMap();
            for (IConfigurationElement el : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.sapphire.modeling", "serializers"))) {
                String declaringBundleId = el.getNamespaceIdentifier();
                if (!el.getName().equals(EL_VALUE_SERIALIZER)) continue;
                SerializerRecord serviceRecord = new SerializerRecord();
                serviceRecord.declaringBundleId = declaringBundleId;
                try {
                    String type = PluginUtil.findRequiredAttribute(el, ATTR_TYPE);
                    serviceRecord.typeClass = PluginUtil.loadClass(declaringBundleId, type, Object.class);
                    String impl = PluginUtil.findRequiredAttribute(el, ATTR_IMPL);
                    serviceRecord.implClass = PluginUtil.loadClass(declaringBundleId, impl, ValueSerializerImpl.class);
                    if (serviceRecord.typeClass == null || serviceRecord.implClass == null) continue;
                    serializers.add(serviceRecord);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
            }
        }
    }

    private static final class SerializerRecord {
        public Class<?> typeClass;
        public Class<ValueSerializerImpl> implClass;
        public String declaringBundleId;

        private SerializerRecord() {
        }
    }
}

