/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.EnablerImpl;

public final class BooleanPropertyEnabler
extends EnablerImpl {
    private ValueProperty property;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        if (params.length != 1) {
            throw new IllegalArgumentException();
        }
        ModelProperty prop = element.getModelElementType().getProperty(params[0]);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        if (prop.getTypeClass() != Boolean.class) {
            throw new IllegalArgumentException();
        }
        this.property = (ValueProperty)prop;
    }

    public boolean isEnabled() {
        IModelElement element = this.getModelElement();
        if (element.isPropertyEnabled(this.property)) {
            Value result;
            try {
                result = (Value)this.property.invokeGetterMethod(element);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Boolean res = (Boolean)result.getContent(true);
            if (res != null && res.booleanValue()) {
                return true;
            }
        }
        return false;
    }
}

