/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesChangedEvent;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleValuesFromModelProvider
extends PossibleValuesProviderImpl {
    private final ModelPath path;
    private Set<String> values;

    public PossibleValuesFromModelProvider(ModelPath path) {
        this.path = path;
        this.values = Collections.emptySet();
    }

    @Override
    public void init(final IModelElement element, ValueProperty property, String invalidValueMessageTemplate, int invalidValueSeverity, boolean isCaseSensitive, String[] params) {
        super.init(element, property, invalidValueMessageTemplate, invalidValueSeverity, isCaseSensitive, params);
        final ModelPropertyListener listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                PossibleValuesFromModelProvider.this.refresh();
            }
        };
        element.addListener(listener, this.path);
        element.addListener(new ModelElementListener(){

            public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                element.removeListener(listener, PossibleValuesFromModelProvider.this.path);
            }
        });
    }

    @Override
    protected void fillPossibleValues(SortedSet<String> values) {
        values.addAll(this.values);
    }

    private void refresh() {
        SortedSet<String> newValues = this.getModelElement().service().read(this.path);
        if (!this.values.equals(newValues)) {
            this.values = Collections.unmodifiableSet(newValues);
            this.notifyListeners(new PossibleValuesChangedEvent());
        }
    }
}

