/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginUtil {
    private static final String ATTR_BUNDLE_VERSION = "Bundle-Version";
    private static final String PLUGIN_LOCATION_PREFIX = "reference:file:";

    private PluginUtil() {
    }

    public static Collection<IExtension> findExtensions(String pluginId, String extensionPointId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPointId);
        if (point == null) {
            throw new RuntimeException();
        }
        ArrayList<IExtension> extensions = new ArrayList<IExtension>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            extensions.add(extension);
            ++n2;
        }
        return extensions;
    }

    public static Collection<IConfigurationElement> getTopLevelElements(Collection<IExtension> extensions) {
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
        for (IExtension extension : extensions) {
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                elements.add(element);
                ++n2;
            }
        }
        return elements;
    }

    public static void reportInvalildElement(IExtension extension, IConfigurationElement element) {
        String msg = NLS.bind((String)Resources.invalidElement, (Object)extension.getSimpleIdentifier(), (Object)element.getName());
        SapphireModelingFrameworkPlugin.logError(msg, null);
    }

    public static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        String msg = NLS.bind((String)Resources.missingAttribute, (Object)el.getName(), (Object)attribute);
        SapphireModelingFrameworkPlugin.logError(msg, null);
    }

    public static void reportMissingElement(IConfigurationElement el, String element) {
        String msg = NLS.bind((String)Resources.missingElement, (Object)el.getName(), (Object)element);
        SapphireModelingFrameworkPlugin.logError(msg, null);
    }

    public static String findRequiredAttribute(IConfigurationElement el, String attribute) throws InvalidExtensionException {
        String val = el.getAttribute(attribute);
        if (val == null) {
            PluginUtil.reportMissingAttribute(el, attribute);
            throw new InvalidExtensionException();
        }
        return val;
    }

    public static IConfigurationElement findRequiredElement(IConfigurationElement el, String childElement) throws InvalidExtensionException {
        IConfigurationElement[] children = el.getChildren(childElement);
        if (children.length == 0) {
            PluginUtil.reportMissingElement(el, childElement);
            throw new InvalidExtensionException();
        }
        return children[0];
    }

    public static IConfigurationElement findOptionalElement(IConfigurationElement el, String childElement) {
        IConfigurationElement[] children = el.getChildren(childElement);
        if (children.length == 0) {
            return null;
        }
        return children[0];
    }

    public static String getElementValue(IConfigurationElement el, String defaultValue) {
        String text;
        if (el != null && (text = el.getValue()) != null && (text = text.trim()).length() > 0) {
            return text;
        }
        return defaultValue;
    }

    public static <T> Class<T> loadClass(String pluginId, String clname) {
        return PluginUtil.loadClass(pluginId, clname, null);
    }

    public static <T> Class<T> loadClass(String pluginId, String clname, Class<T> interfc) {
        Class cl;
        Bundle bundle = Platform.getBundle((String)pluginId);
        try {
            cl = bundle.loadClass(clname);
        }
        catch (Exception e) {
            String msg = Resources.bind((String)Resources.failedToLoadClass, (Object)clname, (Object)pluginId);
            SapphireModelingFrameworkPlugin.logError(msg, e);
            return null;
        }
        if (interfc != null && !interfc.isAssignableFrom(cl)) {
            String msg = Resources.bind((String)Resources.doesNotImplement, (Object)clname, (Object)interfc.getClass().getName());
            SapphireModelingFrameworkPlugin.logError(msg, null);
            return null;
        }
        return cl;
    }

    public static <T> T instantiate(String pluginId, Class<T> cl) {
        try {
            return cl.newInstance();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failedToInstantiate, (Object)cl.getName(), (Object)pluginId);
            SapphireModelingFrameworkPlugin.logError(msg, e);
            return null;
        }
    }

    public static <T> T instantiate(String pluginId, String clname) {
        return PluginUtil.instantiate(pluginId, clname, null);
    }

    public static <T> T instantiate(String pluginId, String clname, Class<T> interfc) {
        Class<T> cl = PluginUtil.loadClass(pluginId, clname, interfc);
        if (cl == null) {
            return null;
        }
        return PluginUtil.instantiate(pluginId, cl);
    }

    public static String getPluginVersion(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        return (String)bundle.getHeaders().get(ATTR_BUNDLE_VERSION);
    }

    public static boolean waitForPluginToActivate(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        return PluginUtil.waitForPluginToActivate(bundle);
    }

    public static boolean waitForPluginToActivate(Bundle bundle) {
        while (bundle.getState() != 32) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public static IPath getPluginLocation(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        return PluginUtil.getPluginLocation(bundle);
    }

    public static IPath getPluginLocation(Bundle bundle) {
        Path pluginLocation;
        String location = bundle.getLocation();
        if (location.startsWith(PLUGIN_LOCATION_PREFIX)) {
            int offset = PLUGIN_LOCATION_PREFIX.length();
            if (location.length() > offset + 1 && location.charAt(offset) == '/') {
                ++offset;
            }
            location = location.substring(offset);
        }
        if ((pluginLocation = new Path(location)).isAbsolute()) {
            return pluginLocation;
        }
        String installPath = Platform.getInstallLocation().getURL().getPath();
        return new Path(String.valueOf(installPath) + "/" + pluginLocation);
    }

    public static final class ClassInfo {
        public final String pluginId;
        public final String className;

        public ClassInfo(String pluginId, String className) {
            this.pluginId = pluginId;
            this.className = className;
        }
    }

    public static final class InvalidExtensionException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    private static final class Resources
    extends NLS {
        public static String invalidElement;
        public static String missingAttribute;
        public static String missingElement;
        public static String failedToLoadClass;
        public static String failedToInstantiate;
        public static String doesNotImplement;

        static {
            Resources.initializeMessages((String)PluginUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

