/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.xml.schema.DTDParser;
import org.eclipse.sapphire.modeling.xml.schema.XmlChoiceGroup;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModelReference;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinitionByReference;
import org.eclipse.sapphire.modeling.xml.schema.XmlGroupContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlDocumentSchema {
    private String namespace;
    private String schemaLocation;
    private final Map<String, String> importedNamespaces;
    private final Map<String, XmlContentModel> contentModels;
    private final Map<String, XmlElementDefinition> topLevelElements;

    public XmlDocumentSchema(String schemaLocation, String baseLocation) {
        this.schemaLocation = schemaLocation;
        this.importedNamespaces = new HashMap<String, String>();
        this.contentModels = new HashMap<String, XmlContentModel>();
        this.topLevelElements = new HashMap<String, XmlElementDefinition>();
        this.parseSchema(schemaLocation, baseLocation);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getSchemaLocation(String namespace) {
        if (namespace.equals(this.namespace)) {
            return this.schemaLocation;
        }
        return this.importedNamespaces.get(namespace);
    }

    public Map<String, String> getSchemaLocations() {
        HashMap<String, String> schemaLocations = new HashMap<String, String>();
        if (this.namespace != null && this.schemaLocation != null) {
            schemaLocations.put(this.namespace, this.schemaLocation);
        }
        schemaLocations.putAll(this.importedNamespaces);
        return Collections.unmodifiableMap(schemaLocations);
    }

    public XmlElementDefinition getElement(String name) {
        return this.topLevelElements.get(name);
    }

    public XmlContentModel getContentModel(String name) {
        return this.contentModels.get(name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (XmlElementDefinition xmlElementDefinition : this.topLevelElements.values()) {
            xmlElementDefinition.toString(buf, "");
            buf.append("\n\n");
        }
        for (Map.Entry entry : this.contentModels.entrySet()) {
            buf.append((String)entry.getKey());
            buf.append(" = ");
            ((XmlContentModel)entry.getValue()).toString(buf, "");
            buf.append("\n\n");
        }
        return buf.toString();
    }

    private QName createContentModelName() {
        int counter = 1;
        String contentModelName = null;
        do {
            contentModelName = "##@" + String.valueOf(counter);
            ++counter;
        } while (this.contentModels.containsKey(contentModelName));
        return new QName(this.namespace, contentModelName);
    }

    private void parseSchema(String schemaLocation, String baseLocation) {
        URIResolver idResolver = URIResolverPlugin.createResolver();
        String resolvedSchemaLocation = null;
        try {
            resolvedSchemaLocation = idResolver.resolve(baseLocation, null, schemaLocation);
        }
        catch (Exception e) {
            SapphireModelingFrameworkPlugin.log(e);
        }
        if (resolvedSchemaLocation == null) {
            resolvedSchemaLocation = schemaLocation;
        }
        if (resolvedSchemaLocation.endsWith("dtd")) {
            this.namespace = "";
            DTDParser.parse(resolvedSchemaLocation, this, this.contentModels, this.topLevelElements);
            return;
        }
        Element root = XmlDocumentSchema.parse(resolvedSchemaLocation);
        if (root != null) {
            String ns = root.getAttribute("targetNamespace");
            if (ns.length() > 0) {
                this.namespace = ns;
            }
        } else {
            return;
        }
        HashMap<String, String> prefixToNamespaceMap = new HashMap<String, String>();
        NamedNodeMap rootAttributes = root.getAttributes();
        int i = 0;
        int n = rootAttributes.getLength();
        while (i < n) {
            Node attributeNode = rootAttributes.item(i);
            String attributeNodeName = attributeNode.getNodeName();
            String attributeNodeValue = ((Attr)attributeNode).getValue();
            if (attributeNodeName.equals("xmlns")) {
                prefixToNamespaceMap.put("", attributeNodeValue);
            } else if (attributeNodeName.startsWith("xmlns:")) {
                prefixToNamespaceMap.put(attributeNodeName.substring(6), attributeNodeValue);
            }
            ++i;
        }
        if (!prefixToNamespaceMap.containsValue(this.namespace)) {
            prefixToNamespaceMap.put("", this.namespace);
        }
        for (Element importElement : XmlDocumentSchema.elements(root, "import")) {
            String importedNamespace = importElement.getAttribute("namespace");
            String importedSchemaLocation = importElement.getAttribute("schemaLocation");
            if (this.importedNamespaces.containsKey(importedNamespace)) continue;
            this.importedNamespaces.put(importedNamespace, importedSchemaLocation);
        }
        for (Element includeElement : XmlDocumentSchema.elements(root, "include")) {
            String includedSchemaLocation = includeElement.getAttribute("schemaLocation").trim();
            if (!includedSchemaLocation.startsWith("http://")) {
                int lastSlash = this.schemaLocation.lastIndexOf(47);
                String baseUrl = lastSlash == -1 ? this.schemaLocation : this.schemaLocation.substring(0, lastSlash);
                includedSchemaLocation = String.valueOf(baseUrl) + "/" + includedSchemaLocation;
            }
            this.parseSchema(includedSchemaLocation, baseLocation);
        }
        for (Element el : XmlDocumentSchema.elements(root)) {
            String elname = el.getLocalName();
            if (elname.equals("complexType") || elname.equals("group")) {
                String name = el.getAttribute("name");
                XmlContentModel contentModel = this.parseContentModel(prefixToNamespaceMap, el);
                if (contentModel == null) continue;
                this.contentModels.put(name, contentModel);
                continue;
            }
            if (!elname.equals("element")) continue;
            XmlElementDefinition xmlElementDefinition = this.parseElement(prefixToNamespaceMap, el);
            this.topLevelElements.put(xmlElementDefinition.getName().getLocalPart(), xmlElementDefinition);
        }
    }

    private XmlContentModel parseContentModel(Map<String, String> prefixToNamespaceMap, Element el) {
        String elname = el.getLocalName();
        if (elname.equals("complexType") || elname.equals("complexContent")) {
            XmlContentModel contentModel = null;
            for (Element x : XmlDocumentSchema.elements(el)) {
                contentModel = this.parseContentModel(prefixToNamespaceMap, x);
                if (contentModel == null) continue;
                return contentModel;
            }
            return null;
        }
        if (elname.equals("sequence") || elname.equals("choice")) {
            String minOccursStr = el.getAttribute("minOccurs");
            String maxOccursStr = el.getAttribute("maxOccurs");
            int minOccurs = 1;
            int maxOccurs = 1;
            if (minOccursStr.length() > 0) {
                try {
                    minOccurs = Integer.parseInt(minOccursStr);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (maxOccursStr.equalsIgnoreCase("unbounded")) {
                maxOccurs = -1;
            } else if (maxOccursStr.length() > 0) {
                try {
                    maxOccurs = Integer.parseInt(maxOccursStr);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ArrayList<XmlContentModel> nestedContentModels = new ArrayList<XmlContentModel>();
            for (Element x : XmlDocumentSchema.elements(el)) {
                XmlContentModel cm = this.parseContentModel(prefixToNamespaceMap, x);
                if (cm == null) continue;
                nestedContentModels.add(cm);
            }
            if (elname.equals("sequence")) {
                return new XmlSequenceGroup(this, minOccurs, maxOccurs, nestedContentModels);
            }
            return new XmlChoiceGroup(this, minOccurs, maxOccurs, nestedContentModels);
        }
        if (elname.equals("extension")) {
            ArrayList<XmlContentModel> nestedContentModels = new ArrayList<XmlContentModel>();
            String base = el.getAttribute("base");
            if (base != null) {
                QName qname = XmlDocumentSchema.parseQName(base, prefixToNamespaceMap);
                nestedContentModels.add(new XmlContentModelReference(this, qname, 1, 1));
            }
            for (Element x : XmlDocumentSchema.elements(el)) {
                XmlContentModel cm = this.parseContentModel(prefixToNamespaceMap, x);
                if (cm == null) continue;
                nestedContentModels.add(cm);
            }
            return new XmlSequenceGroup(this, 1, 1, nestedContentModels);
        }
        if (elname.equals("element")) {
            return this.parseElement(prefixToNamespaceMap, el);
        }
        if (elname.equals("group")) {
            if (el.getAttribute("name").length() > 0) {
                for (Element x : XmlDocumentSchema.elements(el)) {
                    String xname = x.getLocalName();
                    if (!xname.equals("sequence") && !xname.equals("choice")) continue;
                    return this.parseContentModel(prefixToNamespaceMap, x);
                }
                return null;
            }
            String ref = el.getAttribute("ref");
            QName qname = XmlDocumentSchema.parseQName(ref, prefixToNamespaceMap);
            String minOccursStr = el.getAttribute("minOccurs");
            String maxOccursStr = el.getAttribute("maxOccurs");
            int minOccurs = 1;
            int maxOccurs = 1;
            if (minOccursStr.length() > 0) {
                try {
                    minOccurs = Integer.parseInt(minOccursStr);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (maxOccursStr.equalsIgnoreCase("unbounded")) {
                maxOccurs = -1;
            } else if (maxOccursStr.length() > 0) {
                try {
                    maxOccurs = Integer.parseInt(maxOccursStr);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return new XmlContentModelReference(this, qname, minOccurs, maxOccurs);
        }
        if (elname.equals("any") || elname.equals("annotation") || elname.equals("simpleContent") || elname.equals("attribute")) {
            return null;
        }
        throw new RuntimeException(elname);
    }

    private XmlElementDefinition parseElement(Map<String, String> prefixToNamespaceMap, Element el) {
        QName qname = null;
        QName contentTypeName = null;
        boolean isReference = false;
        String ref = el.getAttribute("ref");
        if (ref.length() > 0) {
            String refLocalName;
            String refNamespacePrefix;
            int colon = ref.indexOf(58);
            if (colon == -1) {
                refNamespacePrefix = "";
                refLocalName = ref;
            } else {
                refNamespacePrefix = ref.substring(0, colon);
                refLocalName = ref.substring(colon + 1);
            }
            String refNamespace = prefixToNamespaceMap.get(refNamespacePrefix);
            qname = new QName(refNamespace, refLocalName);
            isReference = true;
        }
        if (qname == null) {
            String name = el.getAttribute("name");
            qname = new QName(this.namespace, name);
            Element complexTypeElement = XmlDocumentSchema.element(el, "complexType");
            if (complexTypeElement != null) {
                contentTypeName = this.createContentModelName();
                this.contentModels.put(contentTypeName.getLocalPart(), null);
                XmlContentModel contentModel = this.parseContentModel(prefixToNamespaceMap, complexTypeElement);
                if (contentModel == null) {
                    this.contentModels.remove(contentTypeName.getLocalPart());
                    contentTypeName = null;
                } else if (contentModel instanceof XmlGroupContentModel && ((XmlGroupContentModel)contentModel).getNestedContent().isEmpty()) {
                    this.contentModels.remove(contentTypeName.getLocalPart());
                    contentTypeName = null;
                } else {
                    this.contentModels.put(contentTypeName.getLocalPart(), contentModel);
                }
            } else {
                String typeAttribute = el.getAttribute("type");
                if (typeAttribute != null) {
                    contentTypeName = XmlDocumentSchema.parseQName(typeAttribute, prefixToNamespaceMap);
                }
            }
        }
        String minOccursStr = el.getAttribute("minOccurs");
        String maxOccursStr = el.getAttribute("maxOccurs");
        int minOccurs = 1;
        int maxOccurs = 1;
        if (minOccursStr.length() > 0) {
            try {
                minOccurs = Integer.parseInt(minOccursStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (maxOccursStr.equalsIgnoreCase("unbounded")) {
            maxOccurs = -1;
        } else if (maxOccursStr.length() > 0) {
            try {
                maxOccurs = Integer.parseInt(maxOccursStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (isReference) {
            return new XmlElementDefinitionByReference(this, qname, minOccurs, maxOccurs);
        }
        return new XmlElementDefinition(this, qname, contentTypeName, minOccurs, maxOccurs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Element parse(String schemaLocation) {
        DocumentBuilder docbuilder;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(false);
            docbuilder = factory.newDocumentBuilder();
            docbuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            InputStream in;
            block13: {
                Element element;
                URL schemaLocationUrl = new URL(schemaLocation);
                in = null;
                try {
                    in = schemaLocationUrl.openStream();
                    Document doc = docbuilder.parse(in);
                    if (doc == null) break block13;
                    element = doc.getDocumentElement();
                    if (in == null) return element;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                    return element;
                }
                catch (IOException iOException) {}
                return element;
            }
            if (in == null) return null;
            try {
                in.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception e) {
            String message = NLS.bind((String)Resources.parseFailed, (Object)schemaLocation);
            IStatus st = SapphireModelingFrameworkPlugin.createWarningStatus(message, e);
            SapphireModelingFrameworkPlugin.log(st);
        }
        return null;
    }

    private static QName parseQName(String qname, Map<String, String> prefixToNamespaceMap) {
        String refLocalName;
        String refNamespacePrefix;
        int colon = qname.indexOf(58);
        if (colon == -1) {
            refNamespacePrefix = "";
            refLocalName = qname;
        } else {
            refNamespacePrefix = qname.substring(0, colon);
            refLocalName = qname.substring(colon + 1);
        }
        String refNamespace = prefixToNamespaceMap.get(refNamespacePrefix);
        return new QName(refNamespace, refLocalName);
    }

    private static String basename(String name) {
        int colon = name.indexOf(58);
        if (colon != -1) {
            return name.substring(colon + 1);
        }
        return name;
    }

    private static Element element(Element el, String name) {
        NodeList nodes = el.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && XmlDocumentSchema.basename(node.getNodeName()).equals(name)) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    private static Iterable<Element> elements(Element el) {
        return new ElementsIterator(el.getChildNodes());
    }

    private static Iterable<Element> elements(Element el, String name) {
        return new ElementsIterator(el.getChildNodes(), name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ElementsIterator
    implements Iterator<Element>,
    Iterable<Element> {
        private final NodeList nodes;
        private final int length;
        private final String name;
        private int position;
        private Element element;

        public ElementsIterator(NodeList nodes) {
            this(nodes, null);
        }

        public ElementsIterator(NodeList nodes, String name) {
            this.nodes = nodes;
            this.length = nodes.getLength();
            this.position = -1;
            this.name = name;
            this.advance();
        }

        private void advance() {
            this.element = null;
            ++this.position;
            while (this.position < this.length && this.element == null) {
                Node node = this.nodes.item(this.position);
                if (node.getNodeType() == 1 && (this.name == null || XmlDocumentSchema.basename(node.getNodeName()).equals(this.name))) {
                    this.element = (Element)node;
                }
                ++this.position;
            }
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public Element next() {
            Element el = this.element;
            if (el == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return el;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Element> iterator() {
            return this;
        }
    }

    private static final class Resources
    extends NLS {
        public static String parseFailed;

        static {
            Resources.initializeMessages((String)XmlDocumentSchema.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

