/******************************************************************************
 * Copyright (c) 2011 Oracle
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Konstantin Komissarchik - initial implementation and ongoing maintenance
 ******************************************************************************/

package org.eclipse.sapphire.modeling.java.internal;

import org.eclipse.sapphire.modeling.java.JavaPackageName;
import org.eclipse.sapphire.modeling.serialization.ValueSerializerImpl;

/**
 * @author <a href="mailto:konstantin.komissarchik@oracle.com">Konstantin Komissarchik</a>
 */

public final class JavaPackageNameSerializer

    extends ValueSerializerImpl<JavaPackageName>
    
{
    @Override
    protected JavaPackageName decodeFromString( final String value )
    {
        return new JavaPackageName( value );
    }
    
}
