/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.UrlModelStore;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleResourceModelStore
extends UrlModelStore {
    private final String bundleId;
    private final String path;

    public BundleResourceModelStore(String bundleId, String path) {
        super(BundleResourceModelStore.toUrl(bundleId, path, true));
        this.bundleId = bundleId;
        this.path = path;
    }

    @Override
    public boolean isOutOfDate() {
        return false;
    }

    @Override
    protected Map<String, String> loadLocalizedResources(Locale locale) {
        int lastDot = this.path.lastIndexOf(46);
        if (lastDot != -1) {
            URL resFileUrl;
            String resFilePath = this.path.substring(0, lastDot);
            String localeString = locale.toString();
            if (localeString.length() > 0) {
                resFilePath = String.valueOf(resFilePath) + "_" + localeString;
            }
            if ((resFileUrl = BundleResourceModelStore.toUrl(this.bundleId, resFilePath = String.valueOf(resFilePath) + ".properties", false)) != null) {
                Properties props = new Properties();
                try {
                    InputStream stream = resFileUrl.openStream();
                    try {
                        props.load(stream);
                    }
                    catch (Throwable throwable) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (IOException e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
                HashMap<String, String> resources = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    resources.put((String)entry.getKey(), (String)entry.getValue());
                }
                return resources;
            }
        }
        return null;
    }

    private static final URL toUrl(String bundleId, String path, boolean throwExceptionOnNotFound) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (url == null && throwExceptionOnNotFound) {
            String msg = NLS.bind((String)Resources.couldNotFindBundleResource, (Object)bundleId, (Object)path);
            throw new IllegalArgumentException(msg);
        }
        return url;
    }

    private static final class Resources
    extends NLS {
        public static String couldNotFindBundleResource;

        static {
            Resources.initializeMessages((String)BundleResourceModelStore.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

