/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LayeredModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelimitedListController<T extends IModelElement>
extends LayeredModelElementListController<T, Entry> {
    private final char delimiter;
    private Entry head;

    public DelimitedListController(char delimiter) {
        this.delimiter = delimiter;
        this.head = null;
    }

    @Override
    public final List<T> refresh(List<T> contents) {
        List<String> strings = this.split(this.read());
        int count = strings.size();
        if (count == 0) {
            this.head = null;
        } else {
            if (this.head == null) {
                this.head = new Entry(this);
            }
            int i = 0;
            Entry prev = null;
            Object entry = this.head;
            while (i < count && entry != null) {
                ((Entry)entry).value = strings.get(i);
                ++i;
                prev = entry;
                entry = ((Entry)entry).next;
            }
            entry = prev;
            while (((Entry)entry).next != null) {
                ((Entry)entry).next.remove();
            }
            while (i < count) {
                entry = ((Entry)entry).insertAfter();
                ((Entry)entry).value = strings.get(i);
                ++i;
            }
        }
        ArrayList<Entry> base = new ArrayList<Entry>();
        if (this.head != null) {
            Entry entry = this.head;
            while (entry != null) {
                base.add(entry);
                entry = entry.next;
            }
        }
        List<T> result = this.refresh(contents, base);
        for (Object entry : result) {
            entry.refresh();
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final T createNewElement(ModelElementType type) {
        block1: {
            this.getModelElement().getModel().validateEdit();
            entry = this.head;
            if (entry != null) ** GOTO lbl7
            this.head = entry = new Entry(this);
            break block1;
lbl-1000:
            // 1 sources

            {
                entry = Entry.access$1(entry);
lbl7:
                // 2 sources

                ** while (Entry.access$1((Entry)entry) != null)
            }
lbl8:
            // 1 sources

            entry = Entry.access$2(entry);
        }
        this.save();
        return this.wrap(entry);
    }

    @Override
    public final void swap(T x, T y) {
        Entry a = (Entry)this.unwrap(x);
        Entry b = (Entry)this.unwrap(y);
        if (a.next == b) {
            Entry aPrev = a.prev;
            Entry bNext = b.next;
            a.prev = b;
            a.next = bNext;
            b.prev = aPrev;
            b.next = a;
            if (aPrev != null) {
                aPrev.next = b;
            }
            if (bNext != null) {
                bNext.prev = a;
            }
            if (a == this.head) {
                this.head = b;
            }
        } else if (b.next == a) {
            this.swap(y, x);
        } else {
            throw new UnsupportedOperationException();
        }
        this.save();
    }

    protected abstract String read();

    protected abstract void write(String var1);

    private void save() {
        String str;
        if (this.head == null) {
            str = null;
        } else {
            StringBuilder buf = new StringBuilder();
            Entry entry = this.head;
            while (entry != null) {
                String val;
                if (entry != this.head) {
                    buf.append(this.delimiter);
                }
                if ((val = entry.getValue()) != null) {
                    buf.append(val);
                }
                entry = entry.next;
            }
            str = buf.toString();
        }
        this.write(str);
    }

    private List<String> split(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            int n = str.length();
            while (i < n) {
                char ch = str.charAt(i);
                if (ch == this.delimiter) {
                    list.add(buf.toString());
                    buf = new StringBuilder();
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            list.add(buf.toString());
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry {
        private DelimitedListController<?> controller;
        private Entry prev;
        private Entry next;
        private String value;

        public Entry(DelimitedListController<?> controller) {
            this.controller = controller;
            this.prev = null;
            this.next = null;
            this.value = null;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            List segments = ((DelimitedListController)this.controller).split(value);
            int count = segments.size();
            if (count == 0) {
                this.value = null;
            } else {
                this.value = (String)segments.get(0);
                int i = 1;
                while (i < count) {
                    Entry entry = this.insertAfter();
                    entry.setValue((String)segments.get(i));
                    ++i;
                }
            }
            ((DelimitedListController)this.controller).save();
        }

        public void remove() {
            if (this == ((DelimitedListController)this.controller).head) {
                ((DelimitedListController)this.controller).head = this.next;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.prev = null;
            this.next = null;
            ((DelimitedListController)this.controller).save();
        }

        private Entry insertAfter() {
            Entry entry = new Entry(this.controller);
            entry.prev = this;
            entry.next = this.next;
            this.next = entry;
            if (entry.next != null) {
                entry.next.prev = entry;
            }
            return entry;
        }
    }
}

