/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.modeling.ByteArrayModelStore;
import org.eclipse.sapphire.modeling.IEclipseFileModelStore;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.util.internal.FileUtil;

public class EclipseFileModelStore
extends ByteArrayModelStore
implements IEclipseFileModelStore {
    private final IFile file;
    private long modStamp;

    public EclipseFileModelStore(IFile file) {
        this.file = file;
        this.modStamp = -1L;
    }

    public IFile getEclipseFile() {
        return this.file;
    }

    public File getFile() {
        return this.file.getLocation().toFile();
    }

    public void open() throws IOException {
        if (this.file.exists()) {
            InputStream in = null;
            try {
                try {
                    this.modStamp = this.file.getModificationStamp();
                    in = this.file.getContents();
                    this.setContents(in);
                }
                catch (CoreException e) {
                    throw new IOException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            this.setContents(EMPTY_BYTE_ARRAY);
            this.modStamp = -1L;
        }
    }

    public void save() throws IOException {
        if (this.validateEdit()) {
            try {
                byte[] content = this.getContents();
                ByteArrayInputStream stream = new ByteArrayInputStream(content);
                if (this.file.exists()) {
                    this.file.setContents((InputStream)stream, true, false, null);
                } else if (content.length > 0) {
                    FileUtil.mkdirs(this.file.getParent().getLocation().toFile());
                    this.file.create((InputStream)stream, true, null);
                }
                this.modStamp = this.file.getModificationStamp();
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            throw new ValidateEditException();
        }
    }

    public boolean validateEdit() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        return ws.validateEdit(new IFile[]{this.file}, IWorkspace.VALIDATE_PROMPT).isOK();
    }

    public boolean isOutOfDate() {
        return this.modStamp != this.file.getModificationStamp();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EclipseFileModelStore) {
            return this.file.getLocation().equals((Object)((EclipseFileModelStore)obj).getEclipseFile().getLocation());
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

