/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.LabelTransformer;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.annotations.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumValueType
extends ModelMetadataItem {
    private Class<?> enumClass;
    private Map<String, String> resources;

    public EnumValueType(Class<?> enumClass) {
        this.enumClass = enumClass;
        this.resources = null;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type, boolean localOnly) {
        return this.enumClass.getAnnotation(type);
    }

    public <A extends Annotation> A getAnnotation(Enum<?> enumItem, Class<A> type) {
        Field enumItemField;
        try {
            enumItemField = this.enumClass.getField(enumItem.name());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return enumItemField.getAnnotation(type);
    }

    public Enum<?>[] getItems() {
        try {
            Method valuesMethod = this.enumClass.getMethod("values", new Class[0]);
            return (Enum[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getLabelResourceKeyBase() {
        return "$type$";
    }

    @Override
    protected String getDefaultLabel() {
        String className = this.enumClass.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        return this.transformCamelCaseToLabel(className);
    }

    public String getLabel(Enum<?> enumItem, boolean longLabel, CapitalizationType capitalizationType, boolean includeMnemonic) {
        String labelText = null;
        Label labelAnnotation = this.getAnnotation(enumItem, Label.class);
        if (labelAnnotation != null) {
            String labelResourceKey;
            if (longLabel) {
                labelResourceKey = String.valueOf(enumItem.name()) + ".full";
                labelText = this.getResource(labelResourceKey);
            }
            if (labelText == null) {
                labelResourceKey = String.valueOf(enumItem.name()) + ".standard";
                labelText = this.getResource(labelResourceKey);
            }
        }
        labelText = labelText != null ? LabelTransformer.transform(labelText, capitalizationType, includeMnemonic) : enumItem.name();
        return labelText;
    }

    @Override
    public synchronized String getResource(String key) {
        if (this.resources == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.enumClass.getName(), Locale.getDefault(), this.enumClass.getClassLoader());
            this.resources = new HashMap<String, String>();
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                String k = keys.nextElement();
                this.resources.put(k, resourceBundle.getString(k));
            }
        }
        return this.resources.get(key);
    }
}

