/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.modeling.CorruptedModelStoreExceptionInterceptor;
import org.eclipse.sapphire.modeling.IEclipseFileModelStore;
import org.eclipse.sapphire.modeling.IFileModelStore;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelStore;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.ValidateEditListener;
import org.eclipse.sapphire.modeling.ValidateEditPolicy;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

public abstract class Model
extends ModelElement
implements IModel {
    private ModelStore modelStore;
    private CorruptedModelStoreExceptionInterceptor corruptedModelStoreExceptionInterceptor;
    private ValidateEditPolicy validateEditPolicy;
    private Set<ValidateEditListener> validateEditListeners;

    public Model(ModelElementType type, ModelStore modelStore) {
        super(type, null, null);
        this.modelStore = modelStore;
        this.corruptedModelStoreExceptionInterceptor = null;
        this.validateEditPolicy = ValidateEditPolicy.ON_EVERY_CHANGE;
        this.validateEditListeners = null;
        try {
            this.modelStore.open();
        }
        catch (IOException e) {
            SapphireModelingFrameworkPlugin.log(e);
        }
    }

    public ModelStore getModelStore() {
        return this.modelStore;
    }

    public File getFile() {
        if (this.modelStore instanceof IFileModelStore) {
            return ((IFileModelStore)((Object)this.modelStore)).getFile();
        }
        return null;
    }

    public IFile getEclipseFile() {
        if (this.modelStore instanceof IEclipseFileModelStore) {
            return ((IEclipseFileModelStore)((Object)this.modelStore)).getEclipseFile();
        }
        return null;
    }

    public IProject getEclipseProject() {
        IFile file = this.getEclipseFile();
        return file == null ? null : file.getProject();
    }

    public final void validateEdit() {
        this.validateEdit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateEdit(boolean saveMethodContext) {
        Model model = this;
        synchronized (model) {
            if (this.validateEditPolicy == ValidateEditPolicy.ON_EVERY_CHANGE || this.validateEditPolicy == ValidateEditPolicy.ON_SAVE && saveMethodContext) {
                if (this.validateEditListeners != null) {
                    for (ValidateEditListener listener : this.validateEditListeners) {
                        if (listener.validateEdit(this)) continue;
                        throw new ValidateEditException();
                    }
                }
                if (!this.modelStore.validateEdit()) {
                    throw new ValidateEditException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addValidateEditListener(ValidateEditListener listener) {
        Model model = this;
        synchronized (model) {
            if (this.validateEditListeners == null) {
                this.validateEditListeners = new CopyOnWriteArraySet<ValidateEditListener>();
            }
            this.validateEditListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeValidateEditListener(ValidateEditListener listener) {
        Model model = this;
        synchronized (model) {
            if (this.validateEditListeners != null) {
                this.validateEditListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ValidateEditPolicy getValidateEditPolicy() {
        Model model = this;
        synchronized (model) {
            return this.validateEditPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValidateEditPolicy(ValidateEditPolicy policy) {
        Model model = this;
        synchronized (model) {
            this.validateEditPolicy = policy;
        }
    }

    public boolean isCorrupted() {
        return false;
    }

    protected final CorruptedModelStoreExceptionInterceptor getCorruptedModelStoreExceptionInterceptor() {
        return this.corruptedModelStoreExceptionInterceptor;
    }

    public final void setCorruptedModelStoreExceptionInterceptor(CorruptedModelStoreExceptionInterceptor interceptor) {
        this.corruptedModelStoreExceptionInterceptor = interceptor;
    }

    public void save() throws IOException {
        this.validateEdit(true);
        this.modelStore.save();
    }
}

